/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.diff;

import com.dassault.cecilia.lib.util.destination.Record;

public class DiffRecord
implements Record {
    private int _line;
    private String _header;
    private String _msg1;
    private String _msg2;
    private Integer _compare;

    public DiffRecord() {
        this(-1, "");
    }

    public DiffRecord(int line) {
        this(line, "");
    }

    public DiffRecord(String header) {
        this(-1, header);
    }

    public DiffRecord(int line, String header) {
        this._line = line;
        this._header = header;
        this._compare = null;
    }

    public DiffRecord(DiffRecord src) {
        this._line = src._line;
        this._header = src._header;
        this._msg1 = src._msg1;
        this._msg2 = src._msg2;
    }

    public DiffRecord setMsg1(String msg) {
        this._msg1 = msg;
        if (this._compare == null) {
            this._compare = -1;
        }
        return this;
    }

    public DiffRecord setMsg2(String msg) {
        this._msg2 = msg;
        if (this._compare == null) {
            this._compare = 1;
        }
        return this;
    }

    public DiffRecord setLine(int line) {
        this._line = line;
        return this;
    }

    public DiffRecord setHeader(String msg) {
        this._header = msg;
        return this;
    }

    public DiffRecord setCompare(int level) {
        this._compare = level;
        return this;
    }

    public int getLine() {
        return this._line;
    }

    public int getCompare() {
        if (this._compare == null) {
            return 0;
        }
        if (this._compare < 0) {
            return -1;
        }
        if (this._compare > 0) {
            return 1;
        }
        return 0;
    }

    public String getHeader() {
        return this._header;
    }

    public String getMsg1() {
        return this._msg1;
    }

    public String getMsg2() {
        return this._msg2;
    }
}

