/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.io;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class FileUtility {
    protected static boolean __WIN = System.getProperty("os.name").contains("Win");
    protected static final Pattern PATTERN_PROTECT_FILENAME = Pattern.compile("(\\\\)|(/)|(\\:)|(\\*)|(\\?)|(\\<)|(\\>)|(\\|)|(\")");

    protected static String getPrimaryPath(File ref, File access) {
        String name;
        Object path = "";
        ArrayList<String> refp = new ArrayList<String>();
        for (File cur = ref; cur != null; cur = cur.getParentFile()) {
            String name2 = cur.getName();
            if (name2.length() == 0) {
                name2 = cur.getAbsolutePath();
            }
            refp.add(name2);
        }
        ArrayList<String> accp = new ArrayList<String>();
        for (File cur = access; cur != null; cur = cur.getParentFile()) {
            name = cur.getName();
            if (name.length() == 0) {
                name = cur.getAbsolutePath();
            }
            accp.add(name);
        }
        if (refp.size() == 0 || accp.size() == 0) {
            return path;
        }
        if (refp.get(refp.size() - 1).equals(accp.get(accp.size() - 1))) {
            boolean equal = true;
            while (equal && refp.size() > 1 && accp.size() > 1) {
                refp.remove(refp.size() - 1);
                accp.remove(accp.size() - 1);
                equal = refp.get(refp.size() - 1).equals(accp.get(accp.size() - 1));
            }
            if (refp.size() == 1) {
                if (!equal) {
                    refp.remove(refp.size() - 1);
                    path = (String)path + "..";
                } else {
                    refp.remove(refp.size() - 1);
                    accp.remove(accp.size() - 1);
                    path = (String)path + ".";
                }
            } else {
                if (equal && accp.size() == 1) {
                    refp.remove(refp.size() - 1);
                    accp.remove(accp.size() - 1);
                }
                while (refp.size() > 0) {
                    refp.remove(refp.size() - 1);
                    path = (String)path + "..";
                    if (refp.size() <= 0) continue;
                    path = (String)path + File.separator;
                }
            }
            while (accp.size() > 0) {
                name = (String)accp.remove(accp.size() - 1);
                path = (String)path + File.separator;
                path = (String)path + name;
            }
        } else {
            try {
                path = access.getCanonicalPath();
            }
            catch (IOException e) {
                path = access.getAbsolutePath();
                e.printStackTrace();
            }
        }
        return path;
    }

    public static String getDiffPath(File ref, File acc) {
        try {
            File cref = ref.getCanonicalFile();
            File cacc = acc.getCanonicalFile();
            return FileUtility.getPrimaryPath(cref, cacc);
        }
        catch (IOException e) {
            e.printStackTrace();
            return FileUtility.getPrimaryPath(ref, acc);
        }
    }

    public static String getDiffPath(String ref, String acc) {
        File fref = new File(ref);
        File facc = new File(acc);
        return FileUtility.getDiffPath(fref, facc);
    }

    public static void main(String[] args) {
        JFileChooser dlg = new JFileChooser();
        dlg.setFileSelectionMode(1);
        while (dlg.showOpenDialog(null) != 1) {
            File first = dlg.getSelectedFile();
            if (first == null) {
                return;
            }
            if (dlg.showOpenDialog(null) == 1) {
                return;
            }
            File last = dlg.getSelectedFile();
            if (last == null) {
                return;
            }
            System.out.println("First Path : " + first.getPath());
            System.out.println("Last  Path : " + last.getPath());
            System.out.println("First Name : " + first.getName());
            System.out.println("Last  Name : " + last.getName());
            System.out.println("First AbsolutePath : " + first.getAbsolutePath());
            System.out.println("Last  AbsolutePath : " + last.getAbsolutePath());
            System.out.println("Diff  PrimaryPath : " + FileUtility.getPrimaryPath(first, last));
            System.out.println("--------------------------------------------------\n");
        }
        return;
    }

    public static void recursifDelete(File path) throws IOException {
        if (!path.exists()) {
            throw new IOException("File not found '" + path.getAbsolutePath() + "'");
        }
        if (path.isDirectory()) {
            File[] children = path.listFiles();
            for (int i = 0; children != null && i < children.length; ++i) {
                FileUtility.recursifDelete(children[i]);
            }
            if (!path.delete()) {
                throw new IOException("No delete path '" + path.getAbsolutePath() + "'");
            }
        } else if (!path.delete()) {
            throw new IOException("No delete file '" + path.getAbsolutePath() + "'");
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dest);
        FileChannel channelSrc = fis.getChannel();
        FileChannel channelDest = fos.getChannel();
        channelSrc.transferTo(0L, channelSrc.size(), channelDest);
        fis.close();
        fos.close();
    }

    public static void copyStream(InputStream src, OutputStream dest) throws IOException {
        byte[] buffer = new byte[2048];
        int len = -1;
        while ((len = src.read(buffer)) >= 0) {
            dest.write(buffer, 0, len);
        }
        dest.flush();
    }

    public static void copy(Reader src, Writer dest) throws IOException {
        char[] buffer = new char[2048];
        int len = -1;
        while ((len = src.read(buffer)) >= 0) {
            dest.write(buffer, 0, len);
        }
        dest.flush();
    }

    public static File createSpecifiedFile(String path, String pattern, int base) {
        File file = new File(path);
        if (!file.isDirectory()) {
            return null;
        }
        int cur = base;
        Object[] args;
        String result;
        while ((file = new File(path, result = MessageFormat.format(pattern, args = new Object[]{cur}))).exists()) {
            ++cur;
        }
        return file;
    }

    public static FileFilterExtention createFileFilter(String description, String extention, boolean read) {
        return new FileFilterExtention(description, extention);
    }

    public static boolean verifyPaths(boolean write, Component parent, String title, String ... paths) {
        if (paths.length == 0) {
            return false;
        }
        if (paths.length == 1) {
            return FileUtility.verifyPath(paths[0], write, parent, title);
        }
        ArrayList<File> filesToDelete = new ArrayList<File>();
        for (int i = paths.length - 1; i >= 0; --i) {
            String path = paths[i];
            String mess = null;
            if (path.length() == 0) {
                mess = ResMsgCore.getString((String)"FILE_ERROR_EMPTY");
            } else {
                File file = new File(path);
                if (write) {
                    if (file.isFile()) {
                        if (!file.canWrite()) {
                            mess = ResMsgCore.getString((String)"FILE_ERROR_WRITE_ACCESS");
                        } else if (file.exists()) {
                            filesToDelete.add(file);
                        }
                    } else if (file.getParentFile() == null || !file.getParentFile().isDirectory()) {
                        mess = ResMsgCore.getString((String)"FILE_ERROR_NOFILE");
                    } else if (file.isDirectory()) {
                        mess = ResMsgCore.getString((String)"FILE_ERROR_ISDIRECTORY");
                    }
                } else if (!file.isFile()) {
                    mess = ResMsgCore.getString((String)"FILE_ERROR_NOFILE");
                } else if (!file.canRead()) {
                    mess = ResMsgCore.getString((String)"FILE_ERROR_READ_ACCESS");
                }
            }
            if (mess == null) continue;
            Window owner = SwingUtilities.getWindowAncestor(parent);
            JOptionPane.showMessageDialog(owner, ResMsgCore.msgFormat((String)"FILE_ERROR_TITLE", (Object[])new Object[]{path, mess}), title, 0);
            if (parent instanceof JTextComponent) {
                parent.requestFocus();
            }
            return false;
        }
        if (write && !filesToDelete.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            if (filesToDelete.size() == 1) {
                buffer.append(ResMsgCore.msgFormat((String)"FILE_MSG_EXIST_FRM", (Object[])new Object[]{((File)filesToDelete.get(0)).getPath()}));
            } else {
                buffer.append("<html>");
                for (File file : filesToDelete) {
                    if (buffer.length() > 0) {
                        buffer.append("<BR/>");
                    }
                    buffer.append(ResMsgCore.msgFormat((String)"FILE_MSG_EXIST_FRM", (Object[])new Object[]{file.getPath()}));
                }
                buffer.append("</html>");
            }
            Window owner = SwingUtilities.getWindowAncestor(parent);
            int result = JOptionPane.showConfirmDialog(owner, buffer.toString(), title, 0);
            if (result == 1) {
                if (parent instanceof JTextComponent) {
                    parent.requestFocus();
                }
                return false;
            }
            for (File file : filesToDelete) {
                file.delete();
            }
        }
        return true;
    }

    public static boolean verifyPath(String path, boolean write, Component parent, String title) {
        Window owner = SwingUtilities.getWindowAncestor(parent);
        String mess = "";
        if (path.length() == 0) {
            mess = ResMsgCore.getString((String)"FILE_ERROR_EMPTY");
        } else {
            File file = new File(path);
            if (write) {
                if (file.isFile()) {
                    if (!file.canWrite()) {
                        mess = ResMsgCore.getString((String)"FILE_ERROR_WRITE_ACCESS");
                    } else if (file.exists()) {
                        String display = ResMsgCore.msgFormat((String)"FILE_MSG_EXIST_FRM", (Object[])new Object[]{path});
                        int result = JOptionPane.showConfirmDialog(owner, display, title, 0);
                        if (result == 1) {
                            if (parent instanceof JTextComponent) {
                                parent.requestFocus();
                            }
                            return false;
                        }
                        file.delete();
                    }
                } else if (file.getParentFile() == null || !file.getParentFile().isDirectory()) {
                    mess = ResMsgCore.getString((String)"FILE_ERROR_NOFILE");
                } else if (file.isDirectory()) {
                    mess = ResMsgCore.getString((String)"FILE_ERROR_ISDIRECTORY");
                }
            } else if (!file.isFile()) {
                mess = ResMsgCore.getString((String)"FILE_ERROR_NOFILE");
            } else if (!file.canRead()) {
                mess = ResMsgCore.getString((String)"FILE_ERROR_READ_ACCESS");
            }
        }
        if (mess.length() > 0) {
            JOptionPane.showMessageDialog(owner, ResMsgCore.msgFormat((String)"FILE_ERROR_TITLE", (Object[])new Object[]{path, mess}), title, 0);
            if (parent instanceof JTextComponent) {
                parent.requestFocus();
            }
            return false;
        }
        return true;
    }

    public static String getBasePath(Class define) {
        String nameRes = define.getName().replace('.', '/') + ".class";
        URL url = define.getClassLoader().getResource(nameRes);
        if (url == null) {
            return null;
        }
        try {
            int pos;
            String urlStr = URLDecoder.decode(url.toString(), "UTF-8");
            if (urlStr.startsWith("jar:file:/")) {
                int pos2 = urlStr.indexOf("!");
                if (pos2 != -1 && (pos2 = (urlStr = urlStr.substring(__WIN ? 10 : 9, pos2)).lastIndexOf("/")) != -1) {
                    return urlStr.substring(0, pos2);
                }
            } else if (urlStr.startsWith("file:/") && (pos = urlStr.lastIndexOf(nameRes)) != -1) {
                return urlStr.substring(__WIN ? 6 : 5, pos);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static File findExecuteToPath(String path, String name) {
        File file = new File((String)(path = (String)path + File.separator + name));
        if (file.exists() && file.isFile()) {
            return file;
        }
        if (__WIN) {
            if (!name.toLowerCase().endsWith(".exe") && (file = new File((String)path + ".exe")).exists() && file.isFile()) {
                return file;
            }
            if (!name.toLowerCase().endsWith(".bat") && (file = new File((String)path + ".exe")).exists() && file.isFile()) {
                return file;
            }
        }
        return null;
    }

    public static File findExecute(String defaultPath, boolean pathIsFile, String defaultName, Class currentClass) {
        if (defaultPath != null && defaultPath.length() > 0) {
            File file = new File(defaultPath);
            if (file.exists()) {
                if (pathIsFile) {
                    if (file.isFile()) {
                        return file;
                    }
                } else if (file.isDirectory()) {
                    return FileUtility.findExecuteToPath(file.getAbsolutePath(), defaultName);
                }
            }
            return null;
        }
        String path = FileUtility.getBasePath(currentClass);
        if (path != null) {
            return FileUtility.findExecuteToPath(path, defaultName);
        }
        return null;
    }

    public static File getTmpDir() throws IOException {
        File dir;
        String path = System.getProperty("java.io.tmpdir");
        if (path != null && (dir = new File(path)).exists() && dir.isDirectory()) {
            return dir;
        }
        File file = File.createTempFile("xxxxxx", "xxxx");
        return file.getParentFile();
    }

    public static String convertXML(String data) {
        StringBuffer xmlString = new StringBuffer("");
        char curCar = ' ';
        block7: for (int i = 0; i < data.length(); ++i) {
            curCar = data.charAt(i);
            switch (curCar) {
                case '&': {
                    xmlString.append("&amp;");
                    continue block7;
                }
                case '<': {
                    xmlString.append("&lt;");
                    continue block7;
                }
                case '>': {
                    xmlString.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    xmlString.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    xmlString.append("&quot;");
                    continue block7;
                }
                default: {
                    xmlString.append(curCar);
                }
            }
        }
        return xmlString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        if (file.exists()) {
            if (file.canWrite()) {
                FileOutputStream stream = null;
                try {
                    stream = new FileOutputStream(file, true);
                    boolean bl = true;
                    return bl;
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                finally {
                    if (stream != null) {
                        try {
                            ((OutputStream)stream).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(file, true);
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (stream != null) {
                    try {
                        ((OutputStream)stream).close();
                    }
                    catch (IOException iOException) {}
                }
                if (file.exists()) {
                    file.delete();
                }
            }
        }
        return false;
    }

    public static String protectFilename(String name) {
        return PATTERN_PROTECT_FILENAME.matcher(name).replaceAll("_");
    }

    public static String getFileExt(String fName) {
        int pos = fName.lastIndexOf(".");
        if (pos > 0) {
            return fName.substring(pos, fName.length());
        }
        return "";
    }
}

