/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.io;

import java.io.IOException;
import java.io.Writer;

public class IndentWriter {
    private Writer _write;
    private String _indent;
    private int _cpt;
    private boolean _newLine;
    private boolean _exportString = false;

    public IndentWriter(Writer write, String base) {
        this._write = write;
        this._indent = base;
        this._cpt = 0;
        this._newLine = false;
    }

    private void writeIndent(boolean indent) throws IOException {
        if (!indent) {
            return;
        }
        for (int i = 0; i < this._cpt; ++i) {
            this._write.write(this._indent);
        }
    }

    public void writeEscapeXML(String text) throws IOException {
        this.writeEscapeXML(text, true);
    }

    public void writeEscapeXML(String text, boolean indent) throws IOException {
        if (text == null) {
            text = "&lt;null&gt;";
            this.write(text, indent);
        } else {
            StringBuffer sb = new StringBuffer(text.length() + 5);
            block7: for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '&': {
                        sb.append("&amp;");
                        continue block7;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block7;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block7;
                    }
                    case '\'': {
                        sb.append("&apos;");
                        continue block7;
                    }
                    case '\"': {
                        sb.append("&quot;");
                        continue block7;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            this.write(sb.toString(), indent);
        }
    }

    public void write(String add) throws IOException {
        this.write(add, true);
    }

    public void write(String add, boolean indent) throws IOException {
        int pos;
        if (this._exportString && (pos = add.indexOf(34)) != -1) {
            StringBuffer sb = new StringBuffer((add.length() + 10) * 125 / 100);
            while (pos != -1) {
                sb.append(add.substring(0, pos));
                sb.append("\\\"");
                add = add.substring(pos + 1);
                pos = add.indexOf(10);
            }
            add = sb.toString();
        }
        if (this._newLine) {
            this.writeIndent(indent);
        }
        pos = add.indexOf("\n");
        while (pos != -1) {
            this._write.write(add.substring(0, pos + 1));
            if (pos == add.length() - 1) {
                this._newLine = true;
                return;
            }
            this.writeIndent(indent);
            add = add.substring(pos + 1);
            pos = add.indexOf("\n");
        }
        this._newLine = false;
        this._write.write(add);
    }

    public void addIndent(int mod) {
        this._cpt += mod;
        assert (this._cpt >= 0);
    }

    public void exportString(boolean val) {
        this._exportString = val;
    }

    public void close(boolean writer) throws IOException {
        if (this._newLine) {
            this.writeIndent(true);
        }
        this._newLine = false;
        if (writer) {
            this._write.close();
        } else {
            this._write.flush();
        }
    }

    public void writeAttrWithValue(String attr, String val) throws IOException {
        if (attr == null || attr.isEmpty() || val == null) {
            throw new IOException("writeAttrWithValue() called with null elements");
        }
        this.write(attr);
        this.write("=\"");
        this.write(val.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        this.write("\" ");
    }
}

