/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ProcessLauncher {
    private OutputStream _out = null;
    private OutputStream _err = null;
    private InputStream _in = null;
    private long _timeout = 0L;
    private Process _process;
    private Object _lockProcess = new Object();
    private Integer _status = -1;

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public ProcessLauncher() {
        this(null, null, null, 0L);
    }

    public ProcessLauncher(OutputStream out, OutputStream err) {
        this(out, err, null, 0L);
    }

    public ProcessLauncher(OutputStream out, OutputStream err, InputStream in) {
        this(out, err, in, 0L);
    }

    public ProcessLauncher(OutputStream out, OutputStream err, long timeout) {
        this(out, err, null, timeout);
    }

    public ProcessLauncher(OutputStream out, OutputStream err, InputStream in, long timeout) {
        this._out = out;
        this._err = err;
        this._in = in;
        this._timeout = timeout < 0L ? 0L : timeout;
    }

    public int exec(String command) throws IOException {
        return this.execute(Runtime.getRuntime().exec(command));
    }

    public int exec(String[] cmdarray) throws IOException {
        return this.execute(Runtime.getRuntime().exec(cmdarray));
    }

    public int exec(String[] cmdarray, String[] envp) throws IOException {
        return this.execute(Runtime.getRuntime().exec(cmdarray, envp));
    }

    public int exec(String[] cmdarray, String[] envp, File dir) throws IOException {
        return this.execute(Runtime.getRuntime().exec(cmdarray, envp, dir));
    }

    public int exec(String command, String[] envp) throws IOException {
        return this.execute(Runtime.getRuntime().exec(command, envp));
    }

    public int exec(String command, String[] envp, File dir) throws IOException {
        return this.execute(Runtime.getRuntime().exec(command, envp, dir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this._lockProcess;
        synchronized (object) {
            this._status = 10001;
            if (this._process != null) {
                this._process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(Process process) {
        Thread out;
        Thread err;
        int status = -1;
        Object object = this._lockProcess;
        synchronized (object) {
            this._process = process;
            err = this.createStreamThread(this._process.getErrorStream(), this._err);
            out = this.createStreamThread(this._process.getInputStream(), this._out);
            if (this._in != null) {
                this.createStreamThread(this._in, this._process.getOutputStream());
            }
        }
        if (this._timeout > 0L) {
            processThread = this.createProcessThread(this._process);
            ((Thread)processThread).start();
            try {
                ((Thread)processThread).join(this._timeout);
                Object object2 = this._lockProcess;
                synchronized (object2) {
                    if (this._process != null) {
                        try {
                            status = this._process.exitValue();
                        }
                        catch (IllegalThreadStateException itse) {
                            this._process.destroy();
                            status = 10002;
                        }
                    }
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        } else if (this._timeout == 0L) {
            try {
                this._process.waitFor();
                processThread = this._lockProcess;
                synchronized (processThread) {
                    if (this._process != null) {
                        status = this._process.exitValue();
                    }
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        Object ie = this._lockProcess;
        synchronized (ie) {
            this._process = null;
        }
        while (out.isAlive() || err.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this._status != -1 ? this._status : status;
    }

    private Thread createStreamThread(final InputStream is, final OutputStream os) {
        Thread result = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream bis = is;
                OutputStream bos = null;
                if (os != null) {
                    bos = os;
                }
                byte[] data = new byte[2048];
                int nbRead = 0;
                try {
                    while (ProcessLauncher.this._status == -1 && (nbRead = bis.read(data)) > 0) {
                        if (bos == null) continue;
                        bos.write(data, 0, nbRead);
                        bos.flush();
                    }
                    if (bos != null) {
                        bos.flush();
                    }
                }
                catch (IOException ioe) {
                    for (nbRead = 0; nbRead < 10; ++nbRead) {
                        Object object = ProcessLauncher.this._lockProcess;
                        synchronized (object) {
                            if (ProcessLauncher.this._process == null) {
                                break;
                            }
                        }
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (nbRead == 10) {
                        System.err.println("During copy stream");
                        ioe.printStackTrace();
                    }
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e) {
                            System.err.println("Close output stream");
                            e.printStackTrace();
                        }
                    }
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        System.err.println("Close input stream");
                        e.printStackTrace();
                    }
                }
            }
        });
        result.start();
        return result;
    }

    private Thread createProcessThread(final Process process) {
        return new Thread(){

            @Override
            public void run() {
                try {
                    process.waitFor();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        };
    }
}

