/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.util.xmlparser;

import com.dassault.cecilia.lib.util.xmlparser.xmlException;
import com.dassault.cecilia.lib.util.xmlparser.xmlLexer;
import com.dassault.cecilia.lib.util.xmlparser.xmlNode;
import com.dassault.cecilia.lib.util.xmlparser.xmlTypeNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;

public class xmlParser {
    File _input;
    xmlLexer _lexer;
    int _currentTok = 0;
    LinkedList<xmlNode> _stack = new LinkedList();
    xmlNode _docNode = null;
    boolean _elementInline = false;
    int _previousTok = 0;

    public xmlParser(File input) throws IOException {
        this._input = input;
        this._lexer = new xmlLexer(new InputStreamReader((InputStream)new FileInputStream(input), "ISO-8859-1"));
    }

    public xmlNode nextNode() throws IOException, xmlException {
        if (this._elementInline) {
            this._elementInline = false;
            xmlNode result = new xmlNode(this._stack.removeLast());
            result._type = xmlTypeNode.STOP;
            return result;
        }
        return this.readNode();
    }

    public long nbrChar() {
        return this._lexer.nbchar();
    }

    public long nbrLine() {
        return this._lexer.nbline();
    }

    public void close() throws IOException {
        this._lexer.yyclose();
    }

    private int readToken() throws IOException {
        if (this._previousTok != 0) {
            int result = this._previousTok;
            this._previousTok = 0;
            return result;
        }
        return this._lexer.yylex();
    }

    private void ungetToken(int tok) {
        assert (this._previousTok == 0) : "Previous Token already exist";
        this._previousTok = tok;
    }

    private xmlNode readNode() throws IOException, xmlException {
        int tok = this.readToken();
        switch (tok) {
            case 1400: {
                return this.readExtra(xmlTypeNode.COMMENT, 1401, "");
            }
            case 1300: {
                return this.readExtra(xmlTypeNode.PROCESS, 1301, this._lexer.yytext().substring(2));
            }
            case 1200: {
                return this.readExtra(xmlTypeNode.OTHER, 1201, this._lexer.yytext().substring(2));
            }
            case 1000: {
                return this.readElementStart();
            }
            case 1001: {
                return this.readElementStop();
            }
            case 2000: {
                return this.readEOF();
            }
        }
        return this.readText();
    }

    private xmlNode readExtra(xmlTypeNode type, int endToken, String header) throws IOException {
        StringBuffer sb = new StringBuffer(128);
        sb.append(header);
        int tok = this.readToken();
        while (tok != endToken) {
            sb.append(this._lexer.yytext());
            tok = this.readToken();
        }
        return new xmlNode(this, type, sb.toString(), null);
    }

    private xmlNode readElementStart() throws IOException, xmlException {
        String name = this._lexer.yytext().substring(1);
        HashMap<String, String> attribs = new HashMap<String, String>();
        boolean stop = false;
        while (!stop) {
            int tok = this.readToken();
            if (tok == 1100) {
                String nameAttrib = this._lexer.yytext();
                if (attribs.get(nameAttrib) != null) {
                    throw new xmlException("Attribute '" + nameAttrib + "' already define", this._lexer);
                }
                while ((tok = this.readToken()) == 1102) {
                }
                if (tok != 1004) {
                    throw new xmlException("Syntax error (no assign attribute)", this._lexer);
                }
                while ((tok = this.readToken()) == 1102) {
                }
                if (tok != 1101) {
                    throw new xmlException("Syntax error (no string value attribute)", this._lexer);
                }
                String valAttrib = this._lexer.yytext();
                attribs.put(nameAttrib, valAttrib);
                continue;
            }
            if (tok == 1102) continue;
            if (tok == 1003) {
                stop = true;
                continue;
            }
            if (tok == 1002) {
                stop = true;
                this._elementInline = true;
                continue;
            }
            throw new xmlException("Syntax error (bad token in element)", this._lexer);
        }
        xmlNode result = new xmlNode(this, xmlTypeNode.START, name, attribs);
        if (this._stack.size() == 0) {
            if (this._docNode != null) {
                throw new xmlException("Document node already define", this._lexer);
            }
            this._docNode = result;
        }
        this._stack.addLast(result);
        return result;
    }

    private xmlNode readElementStop() throws IOException, xmlException {
        xmlNode result = new xmlNode(this._stack.removeLast());
        if (!result.getValue().equals(this._lexer.yytext().substring(2))) {
            throw new xmlException("Not closure '" + result.getValue() + "'", this._lexer);
        }
        if (this.readToken() != 1003) {
            throw new xmlException("Syntax error (no '>' end element)", this._lexer);
        }
        result._type = xmlTypeNode.STOP;
        return result;
    }

    private xmlNode readEOF() throws IOException, xmlException {
        if (this._docNode == null) {
            throw new xmlException("Document node no define", this._lexer);
        }
        if (this._stack.size() != 0) {
            throw new xmlException("Element '" + this._stack.getLast().getValue() + "' not closed", this._lexer);
        }
        return new xmlNode(this, xmlTypeNode.ENDSTREAM, null, null);
    }

    private xmlNode readText() throws IOException, xmlException {
        StringBuffer sb = new StringBuffer(256);
        sb.append(this._lexer.yytext());
        boolean stop = false;
        block3: while (!stop) {
            int tok = this.readToken();
            switch (tok) {
                case 1000: 
                case 1001: 
                case 1200: 
                case 1300: 
                case 1400: 
                case 2000: {
                    this.ungetToken(tok);
                    stop = true;
                    continue block3;
                }
            }
            sb.append(this._lexer.yytext());
        }
        if (sb.toString().trim().length() > 0 && this._stack.size() == 0) {
            throw new xmlException("Document node no define", this._lexer);
        }
        return new xmlNode(this, xmlTypeNode.TEXT, sb.toString(), null);
    }

    public String convertEntity(String txt) throws xmlException {
        if (txt.indexOf(38) == -1) {
            return txt;
        }
        StringBuffer sb = new StringBuffer(txt.length());
        char curCar = ' ';
        for (int i = 0; i < txt.length(); ++i) {
            curCar = txt.charAt(i);
            if (curCar == '&') {
                StringBuffer code = new StringBuffer(64);
                boolean stop = false;
                while (!stop) {
                    if (++i >= txt.length()) {
                        throw new xmlException("Entity error", this._lexer);
                    }
                    curCar = txt.charAt(i);
                    if (curCar == ';') {
                        stop = true;
                        String cod = code.toString();
                        if (cod.equals("amp")) {
                            sb.append("&");
                            continue;
                        }
                        if (cod.equals("lt")) {
                            sb.append("<");
                            continue;
                        }
                        if (cod.equals("gt")) {
                            sb.append(">");
                            continue;
                        }
                        if (cod.equals("apos")) {
                            sb.append("'");
                            continue;
                        }
                        if (cod.equals("quot")) {
                            sb.append("\"");
                            continue;
                        }
                        if (cod.equals("#13")) continue;
                        if (cod.equals("#x003A")) {
                            sb.append(":");
                            continue;
                        }
                        if (cod.equals("#x005B")) {
                            sb.append("[");
                            continue;
                        }
                        if (cod.equals("#x005D")) {
                            sb.append("]");
                            continue;
                        }
                        throw new xmlException("Entity unknow : " + cod, this._lexer);
                    }
                    code.append(curCar);
                }
                continue;
            }
            sb.append(curCar);
        }
        return sb.toString();
    }

    public static String toXML(String txt) {
        StringBuffer xmlString = new StringBuffer(txt.length());
        char curCar = ' ';
        block10: for (int i = 0; i < txt.length(); ++i) {
            curCar = txt.charAt(i);
            switch (curCar) {
                case '&': {
                    xmlString.append("&amp;");
                    continue block10;
                }
                case '<': {
                    xmlString.append("&lt;");
                    continue block10;
                }
                case '>': {
                    xmlString.append("&gt;");
                    continue block10;
                }
                case '\'': {
                    xmlString.append("&apos;");
                    continue block10;
                }
                case '\"': {
                    xmlString.append("&quot;");
                    continue block10;
                }
                case ':': {
                    xmlString.append("&#x003A;");
                    continue block10;
                }
                case '[': {
                    xmlString.append("&#x005B;");
                    continue block10;
                }
                case ']': {
                    xmlString.append("&#x005D;");
                    continue block10;
                }
                default: {
                    xmlString.append(curCar);
                }
            }
        }
        return xmlString.toString();
    }
}

