<?xml version="1.0" encoding="iso-8859-15"?>
<xsl:stylesheet 
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version="1.0">

	<xsl:template match="EXPORT">
		<article>
			<xsl:attribute name="id">Project</xsl:attribute>
			<xsl:attribute name="lang">fr</xsl:attribute>
			<section> 
				<xsl:attribute name="id">Systeme</xsl:attribute>
				<title>Systme</title>
				<xsl:apply-templates select="PROJECT"/>
			</section>
			<section> 
				<xsl:attribute name="id">Types</xsl:attribute>
				<title>Types</title>
				<para><emphasis role="bold">Types enumrs</emphasis></para>
				<xsl:apply-templates select="//TYPE_FAMILY//TYPE">
					<xsl:with-param name="isEnum">true</xsl:with-param>
				</xsl:apply-templates>				
				<para><emphasis role="bold">Types structurs</emphasis></para>
				<xsl:apply-templates select="//TYPE_FAMILY//TYPE[@LINK]"/>
			</section>
			<section> 
				<xsl:attribute name="id">Operateurs</xsl:attribute>
				<title>Oprateurs</title>
				<xsl:apply-templates select="//OPERATOR_FAMILY//OPERATOR"/>
			</section>
			<section> 
				<xsl:attribute name="id">Composants</xsl:attribute>
				<title>Composants</title>
				<xsl:apply-templates select="//COMPONENT_FAMILY//COMPONENT_MODEL"/>
			</section>
			<section> 
				<xsl:attribute name="id">Equipements</xsl:attribute>
				<title>Equipements</title>
				<xsl:apply-templates select="//EQUIPMENT_FAMILY//EQUIPMENT_MODEL"/>
			</section>
		</article>
	</xsl:template> 
	
<!-- ================================================== -->
<!--                     Le systme                     -->
<!-- ================================================== -->

<xsl:template match="PROJECT">
	<xsl:apply-templates select="SYSTEM/IDENTIFICATION">
		<xsl:with-param name="label1">Nom du projet</xsl:with-param>
		<xsl:with-param name="label2">Nom du systme</xsl:with-param>
	</xsl:apply-templates>
	<para><emphasis role="bold">Contenu du niveau suprieur</emphasis></para>
	<informaltable> 
		<xsl:attribute name="frame">all</xsl:attribute>
		<tgroup>
			<xsl:attribute name="cols">3</xsl:attribute>
			<colspec>
				<xsl:attribute name="colnum">1</xsl:attribute>
				<xsl:attribute name="colwidth">4cm</xsl:attribute>
			</colspec>
			<colspec>
				<xsl:attribute name="colnum">3</xsl:attribute>
				<xsl:attribute name="colwidth">2cm</xsl:attribute>
			</colspec>
			<thead>
				<row>
					<entry><xsl:attribute name="align">center</xsl:attribute>Nom</entry>
					<entry><xsl:attribute name="align">center</xsl:attribute>Modle</entry>
					<entry><xsl:attribute name="align">center</xsl:attribute>Equipement</entry>
				</row>
			</thead>
			<tbody> 
				<xsl:apply-templates select="SYSTEM/ARCHITECTURE"/>
			</tbody> 
		</tgroup> 
	</informaltable> 
</xsl:template>                

<xsl:template match="ARCHITECTURE">
	<xsl:for-each select=".//COMPONENT | .//EQUIPMENT">
		<row>
			<entry><xsl:value-of select="@NAME"/></entry>
			<entry><xsl:value-of select="@FAMILY"/>/<xsl:value-of select="@MODEL"/>;<xsl:value-of select="@VERSION"/></entry>
			<xsl:choose>
				<xsl:when test="local-name(.)='COMPONENT'">
					<entry>Non</entry>
				</xsl:when>
				<xsl:otherwise>
					<entry>Oui</entry>
				</xsl:otherwise>
			</xsl:choose>				
		</row> 
	</xsl:for-each>
</xsl:template>                	
	
<!-- ================================================== -->
<!--                     Les types                      -->
<!-- ================================================== -->

<xsl:template match="TYPE">
	<xsl:param name="isEnum">false</xsl:param>
	<xsl:choose>
		<xsl:when test="@LINK='1'">
			<xsl:if test="$isEnum='false'">
				<para><emphasis role="bold">Modle de type</emphasis></para>
				<xsl:apply-templates select="IDENTIFICATION">
					<xsl:with-param name="genre">Genre : Structur</xsl:with-param>	
				</xsl:apply-templates>	
			</xsl:if>
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="$isEnum='true'">
				<para><emphasis role="bold">Modle de type</emphasis></para>
				<xsl:apply-templates select="IDENTIFICATION">
					<xsl:with-param name="genre">Genre : Enumr</xsl:with-param>					
				</xsl:apply-templates>
			</xsl:if>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>                

<!-- ================================================== -->
<!--                   Les oprateurs                   -->
<!-- ================================================== -->

<xsl:template match="OPERATOR">
	<para><emphasis role="bold">Modle d'oprateur</emphasis></para>
	<xsl:apply-templates select="IDENTIFICATION"/>
</xsl:template>                	
      
<!-- ================================================== -->
<!--                   Les composants                   -->
<!-- ================================================== -->

	<xsl:template match="COMPONENT_MODEL">
		<para><emphasis role="bold">Modle de composant</emphasis></para>
		<xsl:apply-templates select="IDENTIFICATION"/>
	</xsl:template>                
    
<!-- ================================================== -->
<!--                   Les quipements                  -->
<!-- ================================================== -->

	<xsl:template match="EQUIPMENT_MODEL">
		<para><emphasis role="bold">Modle d'quipement</emphasis></para>
		<xsl:apply-templates select="IDENTIFICATION"/>
	</xsl:template>                
    
<!-- ================================================== -->

	<xsl:template match="IDENTIFICATION">
		<xsl:param name="label1">Nom de la famille</xsl:param>
		<xsl:param name="label2">Nom du modle</xsl:param>
		<xsl:param name="genre"/>
		<para><emphasis role="bold">Identification</emphasis></para>
		<itemizedlist spacing="compact">
			<listitem>
				<para><xsl:value-of select="$label1"/> : <xsl:value-of select="../../IDENTIFICATION/@NAME"/></para>
			</listitem>	
			<listitem>
				<para><xsl:value-of select="$label2"/> : <xsl:value-of select="@NAME"/></para>
			</listitem>
			<listitem>
				<para>Version : <xsl:value-of select="@VERSION"/></para>
			</listitem>
			<xsl:if test="$genre!=''">
				<listitem>
					<para><xsl:value-of select="$genre"/></para>
				</listitem>
			</xsl:if>
			<listitem>
				<para>Modifi le : <xsl:value-of select="@UPDATE_DATE"/> - <xsl:value-of select="@OWNER"/></para>
			</listitem>
		</itemizedlist>
	</xsl:template>
      
              
</xsl:stylesheet>