/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides;

import com.satodev.desktop.ui.StdJFrameManager;
import com.satodev.desktop.ui.table.StdJEntityTablePanel;
import com.satodev.desktop.ui.theme.StdSwingThemes;
import com.satodev.oneui.StdUIUtil;
import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.mapper.StdMapperManager;
import com.satodev.spring.model.enumeration.ProgressionStatus;
import com.satodev.utils.exception.StdApplException;
import com.satodev.utils.log.StdLogger;
import com.satodev.utils.message.StdApplMessages;
import com.satodev.utils.util.StdFileUtil;
import com.satodev.utils.util.StdJarUtil;
import eu.imdr.fides.api.controller.FidesComputationController;
import eu.imdr.fides.api.init.FidesDBInitManager;
import eu.imdr.fides.api.io.read.OpenFidesReadHandler;
import eu.imdr.fides.api.io.read.reader.OpenFidesBOMReader;
import eu.imdr.fides.api.io.read.reader.OpenFidesCustomFamilyReader;
import eu.imdr.fides.api.io.read.reader.OpenFidesMissionProfileReader;
import eu.imdr.fides.api.io.write.OpenFidesWriteManager;
import eu.imdr.fides.api.service.bom.ProductService;
import eu.imdr.fides.computation.FidesComputationProgression;
import eu.imdr.fides.consumer.ResultConsumer;
import eu.imdr.fides.model.DocumentDTO;
import eu.imdr.fides.model.result.ResultDTO;
import eu.imdr.fides.persistence.model.Document;
import eu.imdr.fides.persistence.model.bom.Product;
import eu.imdr.fides.ui.FidesFrame;
import eu.imdr.fides.ui.reporting.ReportingTablePanelProxy;
import eu.imdr.fides.uicontroller.worksheet.FidesWorkSheetManager;
import java.awt.EventQueue;
import java.awt.Window;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class FidesCommandLineRunner
implements CommandLineRunner {
    private static final StdLogger logger = StdLogger.get(FidesCommandLineRunner.class);
    private static final String CERTIFICATE_ISSUER = "CN=JOUBERT Matthieu, OU=SATODEV, O=SATODEV, L=BORDEAUX, ST=GIRONDE, C=FRANCE";

    public void run(String ... args) {
        boolean isJarSigned = true;
        String jarRelativePath = StdSpringUtil.getProperty((String)"std.jar.path");
        if (jarRelativePath != null && !jarRelativePath.isBlank()) {
            try {
                StdJarUtil.checkJarSignature((String)Paths.get(jarRelativePath, new String[0]).toAbsolutePath().normalize().toString(), (String)CERTIFICATE_ISSUER, (String[])new String[]{"fides-", "std-commons-"});
            }
            catch (Exception e) {
                isJarSigned = false;
                logger.error("Invalid signature found for executable Jar", (Throwable)e);
            }
        }
        if (isJarSigned) {
            logger.info("Jar verified !", new Object[0]);
            if (args.length == 0) {
                logger.info("Starting Fides Lab desktop application...", new Object[0]);
                EventQueue.invokeLater(() -> {
                    String privateResourcePath = StdSpringUtil.getPrivateResourcePath();
                    StdFileUtil.deleteDirectory((Path)Path.of(privateResourcePath, new String[0]), (boolean)true);
                    StdSwingThemes.loadTheme((StdSwingThemes.Theme)StdSwingThemes.Theme.FLATLAF);
                    FidesFrame frame = new FidesFrame();
                    frame.setVisible(true);
                    frame.setExtendedState(6);
                    StdJFrameManager frameManager = (StdJFrameManager)StdSpringUtil.getBean((String)"jframeManager", (Object[])new Object[0]);
                    frameManager.addFrame((Window)frame);
                    StdUIUtil.execAsynchronouslyAndWait(listener -> {
                        for (int iter = 0; !FidesDBInitManager.getInstance().isReady() && iter < 30; ++iter) {
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                                logger.error("An error occured while waiting DB initialisation", (Throwable)ex);
                            }
                        }
                    }, () -> {});
                });
            } else {
                logger.info("Starting Fides Lab command line process...", new Object[0]);
                if (args.length >= 2) {
                    String resultPath = args[args.length - 1];
                    String[] files = new String[args.length - 1];
                    System.arraycopy(args, 0, files, 0, args.length - 1);
                    Path resultDirectoryPath = Path.of(resultPath, new String[0]);
                    boolean isOK = StdFileUtil.mkdirs((Path)resultDirectoryPath);
                    if (!isOK) {
                        logger.error("Access denied for target directory : " + resultDirectoryPath, new Object[0]);
                    }
                    try {
                        for (int iter = 0; !FidesDBInitManager.getInstance().isReady() && iter < 30; ++iter) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Cannot init Fides database", new Object[0]);
                        Thread.currentThread().interrupt();
                    }
                    ProductService productService = (ProductService)StdSpringUtil.getBean(ProductService.class, (Object[])new Object[0]);
                    OpenFidesReadHandler handler = new OpenFidesReadHandler(null);
                    for (String arg : files) {
                        File f = new File(arg);
                        if (f.exists()) {
                            StdApplMessages msgs = new StdApplMessages();
                            try {
                                OpenFidesMissionProfileReader mpReader = new OpenFidesMissionProfileReader(handler);
                                OpenFidesCustomFamilyReader cmReader = new OpenFidesCustomFamilyReader(handler);
                                OpenFidesBOMReader itemReader = new OpenFidesBOMReader(handler);
                                mpReader.parseXml(f, true, msgs);
                                cmReader.parseXml(f, true, msgs);
                                List products = productService.getAll();
                                if (products != null && !products.isEmpty()) {
                                    itemReader.setCurrentProduct((Product)products.get(0));
                                }
                                itemReader.parseXml(f, true, msgs);
                            }
                            catch (Exception e) {
                                logger.error(msgs.toString(), (Throwable)e);
                            }
                            continue;
                        }
                        logger.error("Operation canceled, cannot find file " + arg, new Object[0]);
                    }
                    try {
                        FidesComputationController computationController = new FidesComputationController();
                        String computationId = computationController.startComputation(FidesWorkSheetManager.getParentProduct());
                        FidesComputationProgression progression = computationController.getProgression(computationId);
                        for (int cpt = 0; !progression.getStatus().equals((Object)ProgressionStatus.READY) && cpt < 10; ++cpt) {
                            Thread.sleep(1000L);
                            progression = computationController.getProgression(computationId);
                        }
                        DocumentDTO documentDTO = FidesWorkSheetManager.getSelectedDocument();
                        Document document = (Document)StdMapperManager.getMapper(DocumentDTO.class, Document.class).map((Serializable)documentDTO);
                        String documentName = document.getName().toLowerCase();
                        Path resultOpenFidesPath = resultDirectoryPath.resolve(documentName.replace(".fides", "") + "-results.fides");
                        StdFileUtil.deleteIfExists((Path)resultOpenFidesPath);
                        logger.info("Writing OpenFIDES file for to : " + resultOpenFidesPath, new Object[0]);
                        OpenFidesWriteManager writeManager = new OpenFidesWriteManager();
                        String signatureToken = writeManager.writeDocument(document, resultOpenFidesPath.toString(), true);
                        String exportTitleInfo = StdSpringUtil.getMessage((String)("REPORTING_TOKEN: " + signatureToken), (Object[])new Object[0]);
                        ResultConsumer resultConsumer = (ResultConsumer)StdSpringUtil.getBean(ResultConsumer.class, (Object[])new Object[0]);
                        ResultDTO resultDTO = resultConsumer.getResultBy(FidesWorkSheetManager.getParentProduct());
                        ReportingTablePanelProxy panel = new ReportingTablePanelProxy(resultDTO);
                        panel.refreshUI();
                        StdJEntityTablePanel p = (StdJEntityTablePanel)panel.getInstance();
                        Path resultReportingPath = resultDirectoryPath.resolve(documentName.replace(".fides", "") + "-reporting.xlsx");
                        StdFileUtil.deleteIfExists((Path)resultReportingPath);
                        logger.info("Writing Reporting file for to : " + resultReportingPath, new Object[0]);
                        p.exportInternal(resultReportingPath.toFile(), exportTitleInfo, null, new Exception[0]);
                    }
                    catch (StdApplException e) {
                        logger.error("Cannot write result document", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        logger.error("Error while result computation", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }
}

