/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.config;

import com.satodev.desktop.config.StdDesktopUIConfig;
import com.satodev.desktop.ui.form.StdSwingFieldFactory;
import com.satodev.desktop.ui.image.StdSwingIconFactory;
import com.satodev.desktop.ui.theme.StdSwingColorManager;
import com.satodev.desktop.ui.view.StdJApplicationViewRouter;
import com.satodev.oneui.component.StdUIComponent;
import com.satodev.oneui.form.StdUIFieldFactory;
import com.satodev.rest.DataImportConsumer;
import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.StdSpringUtilsConfig;
import com.satodev.spring.i18n.StdCustomI18nProvider;
import com.satodev.spring.i18n.StdLocalProvider;
import com.satodev.spring.mapper.StdMapperManager;
import com.satodev.spring.model.dto.AccessDTO;
import com.satodev.spring.model.dto.ProfileAccessDTO;
import com.satodev.spring.model.dto.ProfileDTO;
import com.satodev.spring.undoredo.StdUndoRedoManager;
import com.satodev.utils.collection.StdPair;
import com.satodev.utils.log.StdLogger;
import eu.imdr.fides.access.FidesAccessManager;
import eu.imdr.fides.api.controller.BOMItemController;
import eu.imdr.fides.api.controller.DataImportController;
import eu.imdr.fides.api.controller.DocumentController;
import eu.imdr.fides.api.controller.FamilyController;
import eu.imdr.fides.api.controller.FidesComputationController;
import eu.imdr.fides.api.controller.FidesFormController;
import eu.imdr.fides.api.controller.FidesParamController;
import eu.imdr.fides.api.controller.IOController;
import eu.imdr.fides.api.controller.LawController;
import eu.imdr.fides.api.controller.MissionProfileController;
import eu.imdr.fides.api.controller.PiController;
import eu.imdr.fides.api.controller.ResultController;
import eu.imdr.fides.api.service.common.AccessService;
import eu.imdr.fides.api.service.common.ProfileService;
import eu.imdr.fides.config.FidesToolAPIConfig;
import eu.imdr.fides.config.FidesToolUIConfig;
import eu.imdr.fides.config.undoredo.FidesUndoRedoHandler;
import eu.imdr.fides.constants.BOMFidesItemType;
import eu.imdr.fides.constants.LawClass;
import eu.imdr.fides.constants.MacroFamily;
import eu.imdr.fides.constants.PiType;
import eu.imdr.fides.constants.PollutionLevel;
import eu.imdr.fides.consumer.BOMItemConsumer;
import eu.imdr.fides.consumer.BomItemDesktopConsumer;
import eu.imdr.fides.consumer.DataImportDesktopConsumer;
import eu.imdr.fides.consumer.DocumentConsumer;
import eu.imdr.fides.consumer.DocumentDesktopConsumer;
import eu.imdr.fides.consumer.FamilyConsumer;
import eu.imdr.fides.consumer.FamilyDesktopConsumer;
import eu.imdr.fides.consumer.FidesComputationConsumer;
import eu.imdr.fides.consumer.FidesComputationDesktopConsumer;
import eu.imdr.fides.consumer.FidesFormConsumer;
import eu.imdr.fides.consumer.FidesFormDesktopConsumer;
import eu.imdr.fides.consumer.FidesParamConsumer;
import eu.imdr.fides.consumer.FidesParamDesktopConsumer;
import eu.imdr.fides.consumer.IOConsumer;
import eu.imdr.fides.consumer.IODesktopConsumer;
import eu.imdr.fides.consumer.LawConsumer;
import eu.imdr.fides.consumer.LawDesktopConsumer;
import eu.imdr.fides.consumer.MissionProfileConsumer;
import eu.imdr.fides.consumer.MissionProfileDesktopConsumer;
import eu.imdr.fides.consumer.PiConsumer;
import eu.imdr.fides.consumer.PiDesktopConsumer;
import eu.imdr.fides.consumer.ResultConsumer;
import eu.imdr.fides.consumer.ResultDesktopConsumer;
import eu.imdr.fides.item.FidesExpression;
import eu.imdr.fides.model.bom.ItemParamAssocDTO;
import eu.imdr.fides.model.bom.ItemParamValueDTO;
import eu.imdr.fides.model.family.FamilyDTO;
import eu.imdr.fides.model.family.StandardFamilyDTO;
import eu.imdr.fides.model.mp.MissionProfileDTO;
import eu.imdr.fides.model.pi.PiDTO;
import eu.imdr.fides.model.referential.form.FidesFormDTO;
import eu.imdr.fides.model.referential.form.FidesResponseDTO;
import eu.imdr.fides.persistence.model.common.Access;
import eu.imdr.fides.persistence.model.common.Profile;
import eu.imdr.fides.persistence.model.common.ProfileAccess;
import eu.imdr.fides.ui.bom.form.BOMInheritedValueRefresher;
import eu.imdr.fides.ui.field.FamilyField;
import eu.imdr.fides.ui.field.FidesExpressionField;
import eu.imdr.fides.ui.field.FidesResponseField;
import eu.imdr.fides.ui.field.ItemParamValueField;
import eu.imdr.fides.ui.field.LawClassField;
import eu.imdr.fides.ui.field.MacroFamilyField;
import eu.imdr.fides.ui.field.MissionProfileField;
import eu.imdr.fides.ui.field.PiField;
import eu.imdr.fides.ui.field.PiFormCodeField;
import eu.imdr.fides.ui.field.PiItemTypeField;
import eu.imdr.fides.ui.field.PollutionLevelField;
import eu.imdr.fides.ui.field.StandardFamilyField;
import eu.imdr.fides.ui.other.AboutPanel;
import eu.imdr.fides.ui.panel.AboutDesktopPanel;
import eu.imdr.fides.ui.panel.ComplianceNotificationDesktopPanel;
import eu.imdr.fides.ui.panel.CustomFamilyDisclaimerPanel;
import eu.imdr.fides.ui.result.compliance.ComplianceNotificationPanel;
import eu.imdr.fides.ui.view.FidesViewRouter;
import eu.imdr.fides.uicontroller.computation.FidesComputationDesktopUIController;
import eu.imdr.fides.uicontroller.computation.FidesComputationUIController;
import eu.imdr.fides.uicontroller.file.FidesFileDesktopUIController;
import eu.imdr.fides.uicontroller.file.FidesFileUIController;
import eu.imdr.fides.uicontroller.file.FidesProperties;
import eu.imdr.fides.uicontroller.file.FidesPropertyNames;
import eu.imdr.fides.uicontroller.worksheet.FidesWorkSheetManagerHolder;
import eu.imdr.fides.uicontroller.worksheet.FidesWorksheetManagerDesktopHolder;
import java.beans.BeanProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@Configuration
@Import(value={StdSpringUtilsConfig.class, StdDesktopUIConfig.class, FidesToolAPIConfig.class, FidesToolUIConfig.class})
@ComponentScan(basePackages={"eu.imdr.fides.ui"})
public class FidesToolDesktopConfig {
    private static final StdLogger logger = StdLogger.get(FidesToolDesktopConfig.class);
    @Value(value="${std.instance.swing-color-manager}")
    private String colorManagerClassName;
    @Value(value="${std.messages.basename}")
    private String messageBaseNames;

    @Bean(value={"customI18nProvider"})
    @Value(value="")
    public StdCustomI18nProvider i18nProvider() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean(value={"swingColorManager"})
    @BeanProperty
    public StdSwingColorManager swingColorManager() {
        if (this.colorManagerClassName != null) {
            try {
                return (StdSwingColorManager)Class.forName(this.colorManagerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                StdLogger.errorAnonymous((String)"Unable to instanciate swingColorManager", (Throwable)e);
            }
        }
        return null;
    }

    @Bean(value={"stdLocalProvider"})
    public StdLocalProvider localProvider() {
        return () -> {
            FidesProperties fidesProperties = new FidesProperties();
            String locale = fidesProperties.getProperty(FidesPropertyNames.LOCALE.name());
            try {
                return new Locale(locale);
            }
            catch (Exception e) {
                return null;
            }
        };
    }

    @Bean(value={"iconFactory"})
    public StdSwingIconFactory iconFactory() {
        return new StdSwingIconFactory("icons-fides");
    }

    @Bean(value={"viewRouter"})
    @Lazy
    public StdJApplicationViewRouter viewRouter() {
        return new FidesViewRouter();
    }

    @Bean(name={"accessManager"})
    @Lazy(value=true)
    public FidesAccessManager accessManager() {
        Supplier<String> cacheVersionKeySupplier = () -> {
            try {
                AccessService accessService = (AccessService)StdSpringUtil.getBean(AccessService.class, (Object[])new Object[0]);
                return accessService.getCacheVersionKey();
            }
            catch (Exception e) {
                logger.error("Unable to load cache version key", (Throwable)e);
                return null;
            }
        };
        Supplier<List> accessSupplier = () -> {
            try {
                AccessService accessService = (AccessService)StdSpringUtil.getBean(AccessService.class, (Object[])new Object[0]);
                List accessList = accessService.getAll();
                return StdMapperManager.getMapper(Access.class, AccessDTO.class).map(accessList);
            }
            catch (Exception e) {
                logger.error("Unable to load access cache", (Throwable)e);
                return new ArrayList();
            }
        };
        Supplier<List> profileAccessSupplier = () -> {
            try {
                AccessService accessService = (AccessService)StdSpringUtil.getBean(AccessService.class, (Object[])new Object[0]);
                List profileAccessList = accessService.getAllProfileAccess();
                return StdMapperManager.getMapper(ProfileAccess.class, ProfileAccessDTO.class).map(profileAccessList);
            }
            catch (Exception e) {
                logger.error("Unable to load profile access cache", (Throwable)e);
                return new ArrayList();
            }
        };
        Supplier<List> profileSupplier = () -> {
            try {
                ProfileService profileService = (ProfileService)StdSpringUtil.getBean(ProfileService.class, (Object[])new Object[0]);
                List profileList = profileService.getAll();
                return StdMapperManager.getMapper(Profile.class, ProfileDTO.class).map(profileList);
            }
            catch (Exception e) {
                logger.error("Unable to load profiles cache", (Throwable)e);
                return null;
            }
        };
        FidesAccessManager bean = new FidesAccessManager(cacheVersionKeySupplier, accessSupplier, profileAccessSupplier, profileSupplier);
        bean.loadAccessCache();
        return bean;
    }

    @Bean(value={"fidesDocumentManagerHolder"})
    public FidesWorkSheetManagerHolder fidesDocumentManagerHolder() {
        return new FidesWorksheetManagerDesktopHolder();
    }

    @Bean(value={"UndoRedoManager"})
    public StdUndoRedoManager undoRedoManager() {
        return new FidesUndoRedoHandler();
    }

    @Bean(value={"fieldFactory"})
    public StdUIFieldFactory fieldFactory() {
        StdSwingFieldFactory bean = new StdSwingFieldFactory();
        bean.registerField(FidesExpression.class, FidesExpressionField::new);
        bean.registerField(MacroFamily.class, param -> {
            StdPair pair = (StdPair)param;
            return new MacroFamilyField((BOMFidesItemType)pair.getE1(), ((Boolean)pair.getE2()).booleanValue());
        });
        bean.registerField(StandardFamilyDTO.class, macroFamily -> new StandardFamilyField((MacroFamily)macroFamily));
        bean.registerField(FamilyDTO.class, param -> {
            StdPair pair = (StdPair)param;
            return new FamilyField((MacroFamily)pair.getE1(), (BOMFidesItemType)pair.getE2());
        });
        bean.registerField(MissionProfileDTO.class, param -> {
            if (param instanceof StdPair) {
                StdPair pair = (StdPair)param;
                return new MissionProfileField(((Boolean)pair.getE1()).booleanValue(), (BOMInheritedValueRefresher)pair.getE2());
            }
            if (param instanceof Boolean) {
                Boolean bool = (Boolean)param;
                return new MissionProfileField(bool.booleanValue());
            }
            return new MissionProfileField();
        });
        bean.registerField(FidesResponseDTO.class, FidesResponseField::new);
        bean.registerField(PiType.class, PiItemTypeField::new);
        bean.registerField(PiDTO.class, param -> {
            if (param instanceof StdPair) {
                StdPair pair = (StdPair)param;
                return new PiField(((Boolean)pair.getE1()).booleanValue(), (BOMInheritedValueRefresher)pair.getE2());
            }
            if (param instanceof Boolean) {
                Boolean bool = (Boolean)param;
                return new PiField(bool.booleanValue());
            }
            return new PiField();
        });
        bean.registerField(PollutionLevel.class, isSaline -> {
            if (isSaline != null) {
                return new PollutionLevelField(((Boolean)isSaline).booleanValue());
            }
            return new PollutionLevelField(false);
        });
        bean.registerField(ItemParamValueDTO.class, assoc -> new ItemParamValueField((ItemParamAssocDTO)assoc));
        bean.registerField(FidesFormDTO.class, formPrefix -> new PiFormCodeField((String)formPrefix));
        bean.registerField(LawClass.class, LawClassField::new);
        return bean;
    }

    @Bean(value={"customFamilyDisclaimerPanel"})
    @Scope(value="prototype")
    public StdUIComponent customFamilyDisclaimerPanel() {
        return new CustomFamilyDisclaimerPanel();
    }

    @Bean(value={"complianceNotificationPanel"})
    @Scope(value="prototype")
    public ComplianceNotificationPanel complianceNotificationPanel() {
        return new ComplianceNotificationDesktopPanel();
    }

    @Bean(value={"aboutPanel"})
    @Scope(value="prototype")
    public AboutPanel aboutPanel() {
        return new AboutDesktopPanel();
    }

    @Bean(value={"fidesFileUIController"})
    public FidesFileUIController fileUIController() {
        return new FidesFileDesktopUIController();
    }

    @Bean(value={"fidesComputationUIController"})
    public FidesComputationUIController computationUIController() {
        return new FidesComputationDesktopUIController();
    }

    @Bean
    public DataImportController dataImportController() {
        return new DataImportController();
    }

    @Bean
    public DocumentController documentController() {
        return new DocumentController();
    }

    @Bean
    public MissionProfileController missionProfileController() {
        return new MissionProfileController();
    }

    @Bean
    public BOMItemController bomItemController() {
        return new BOMItemController();
    }

    @Bean
    public ResultController resultController() {
        return new ResultController();
    }

    @Bean
    public FidesFormController fidesQuestionController() {
        return new FidesFormController();
    }

    @Bean
    public PiController piController() {
        return new PiController();
    }

    @Bean
    public FamilyController familyController() {
        return new FamilyController();
    }

    @Bean
    public FidesParamController fidesParamController() {
        return new FidesParamController();
    }

    @Bean
    public IOController ioController() {
        return new IOController();
    }

    @Bean
    public FidesComputationController fidesComputationController() {
        return new FidesComputationController();
    }

    @Bean
    public LawController lawController() {
        return new LawController();
    }

    @Bean(value={"dataImportConsumer"})
    public DataImportConsumer dataImportConsumer() {
        return new DataImportDesktopConsumer();
    }

    @Bean(value={"documentConsumer"})
    public DocumentConsumer documentConsumer() {
        return new DocumentDesktopConsumer();
    }

    @Bean(value={"missionProfileConsumer"})
    public MissionProfileConsumer missionProfileConsumer() {
        return new MissionProfileDesktopConsumer();
    }

    @Bean(value={"bomItemConsumer"})
    public BOMItemConsumer bomItemConsumer() {
        return new BomItemDesktopConsumer();
    }

    @Bean(value={"resultConsumer"})
    public ResultConsumer resultConsumer() {
        return new ResultDesktopConsumer();
    }

    @Bean(value={"fidesFormConsumer"})
    public FidesFormConsumer fidesQuestionConsumer() {
        return new FidesFormDesktopConsumer();
    }

    @Bean(value={"piConsumer"})
    public PiConsumer piConsumer() {
        return new PiDesktopConsumer();
    }

    @Bean(value={"familyConsumer"})
    public FamilyConsumer familyConsumer() {
        return new FamilyDesktopConsumer();
    }

    @Bean(value={"fidesParamConsumer"})
    public FidesParamConsumer fidesParamConsumer() {
        return new FidesParamDesktopConsumer();
    }

    @Bean(value={"ioConsumer"})
    public IOConsumer ioConsumer() {
        return new IODesktopConsumer();
    }

    @Bean(value={"fidesComputationConsumer"})
    public FidesComputationConsumer fidesComputationConsumer() {
        return new FidesComputationDesktopConsumer();
    }

    @Bean(value={"lawConsumer"})
    public LawConsumer lawConsumer() {
        return new LawDesktopConsumer();
    }
}

