/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.consumer;

import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.jpa.StdQueryDTO;
import com.satodev.utils.exception.StdApplException;
import eu.imdr.fides.api.controller.MissionProfileController;
import eu.imdr.fides.consumer.MissionProfileConsumer;
import eu.imdr.fides.model.DocumentDTO;
import eu.imdr.fides.model.FidesEntityDTO;
import eu.imdr.fides.model.mp.MPPhaseDTO;
import eu.imdr.fides.model.mp.MissionProfileDTO;
import java.math.BigDecimal;
import java.util.List;

public class MissionProfileDesktopConsumer
implements MissionProfileConsumer {
    private final MissionProfileController controller = (MissionProfileController)StdSpringUtil.getBean(MissionProfileController.class, (Object[])new Object[0]);

    public MissionProfileDTO getMissionProfile(Long missionProfileId) throws StdApplException {
        return this.controller.getMissionProfile(missionProfileId);
    }

    public MissionProfileDTO getMissionProfileByExternalId(DocumentDTO document, Long externalId) throws StdApplException {
        return this.controller.getMissionProfileByExternalId(document.getId(), externalId);
    }

    public Long countMissionProfiles(DocumentDTO document, StdQueryDTO query) throws StdApplException {
        return this.controller.countMissionProfiles(document.getId(), query);
    }

    public List<MissionProfileDTO> getMissionProfilesBy(DocumentDTO document, StdQueryDTO query) throws StdApplException {
        return this.controller.getMissionProfiles(document.getId(), query);
    }

    public MissionProfileDTO saveMissionProfile(MissionProfileDTO dto) throws StdApplException {
        return this.controller.saveMissionProfile(dto);
    }

    public void deleteMissionProfile(MissionProfileDTO dto) throws StdApplException {
        this.controller.deleteMissionProfile(dto.getId() != null ? dto.getId().toString() : null);
    }

    public List<MissionProfileDTO> getAllMissionProfilesByIds(List<Long> mpIds) throws StdApplException {
        return this.controller.getAllMissionProfilesByIds(mpIds);
    }

    public boolean copyMPs(DocumentDTO document, List<MissionProfileDTO> mpsToCopy) throws StdApplException {
        return this.controller.copyMPs(document.getId(), mpsToCopy.stream().map(FidesEntityDTO::getId).toList());
    }

    public MPPhaseDTO getMPPhaseByExternalId(DocumentDTO document, Long externalId) throws StdApplException {
        return this.controller.getMPPhaseByExternalId(document.getId(), externalId);
    }

    public Long countMPPhases(MissionProfileDTO missionProfile, StdQueryDTO query) throws StdApplException {
        return this.controller.countMPPhases(missionProfile.getId(), query);
    }

    public List<MPPhaseDTO> getMPPhasesBy(MissionProfileDTO missionProfile, StdQueryDTO query) throws StdApplException {
        return this.controller.getMPPhases(missionProfile.getId(), query);
    }

    public MPPhaseDTO saveMPPhase(MPPhaseDTO dto) throws StdApplException {
        return this.controller.saveMPPhase(dto);
    }

    public void deleteMPPhase(MPPhaseDTO dto) throws StdApplException {
        this.controller.deleteMPPhase(dto.getId() != null ? dto.getId().toString() : null);
    }

    public BigDecimal totalCalendarTime(MissionProfileDTO mp) {
        return this.controller.totalCalendarTime(mp.getId());
    }

    public List<MPPhaseDTO> getMPPhasesBy(List<Long> phaseIds) throws StdApplException {
        return this.controller.getAllMPPhasesByIds(phaseIds);
    }

    public boolean copyMPPhases(MissionProfileDTO parentMP, List<MPPhaseDTO> mpPhasesToCopy) throws StdApplException {
        return this.controller.copyMPPhases(parentMP.getId(), mpPhasesToCopy.stream().map(FidesEntityDTO::getId).toList());
    }
}

