/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.ui.field;

import com.satodev.desktop.ui.button.StdJButton;
import com.satodev.desktop.ui.field.textfield.StdJBigDecimalField;
import com.satodev.desktop.ui.field.textfield.StdJTextField;
import com.satodev.desktop.ui.panel.StdJGBC;
import com.satodev.desktop.ui.panel.StdJPanel;
import com.satodev.oneui.StdUINotificationManager;
import com.satodev.oneui.button.StdUIButton;
import com.satodev.oneui.button.StdUIButtonDescriptor;
import com.satodev.oneui.component.StdUIComponent;
import com.satodev.oneui.form.StdUIField;
import com.satodev.oneui.form.StdUIValueChangeEvent;
import com.satodev.oneui.form.StdUIValueChangeListener;
import com.satodev.oneui.table.StdValueProvider;
import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.util.StdListenerRegistration;
import com.satodev.utils.log.StdLogger;
import com.satodev.utils.util.StdMathUtil;
import eu.imdr.fides.constants.FidesParamCode;
import eu.imdr.fides.item.FidesExpression;
import eu.imdr.fides.model.pi.PiDTO;
import eu.imdr.fides.ui.bom.form.BOMInheritedValueRefresher;
import eu.imdr.fides.ui.bom.form.FidesInheritedValueField;
import eu.imdr.fides.ui.pi.PiDialogProxy;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;

public class PiField
extends StdJPanel
implements StdUIField<PiDTO>,
FidesInheritedValueField {
    private static final StdLogger LOGGER = StdLogger.get(PiField.class);
    private boolean isInherited = false;
    private final BOMInheritedValueRefresher<PiDTO> inheritedValueRefresher;
    private StdJBigDecimalField numberValueField;
    private StdJTextField stringValueField;
    private StdJButton openFormButton;
    private PiDialogProxy piDialog = null;
    private StdJButton clearButton;
    private PiDTO value;
    private boolean readOnly = false;
    private boolean isUserAction = true;
    private final List<StdUIValueChangeListener<PiDTO>> listeners = new ArrayList();

    public PiField() {
        this(false, null);
    }

    public PiField(boolean isInherited) {
        this(isInherited, null);
    }

    public PiField(boolean isInherited, BOMInheritedValueRefresher<PiDTO> inheritedValueRefresher) {
        this.inheritedValueRefresher = inheritedValueRefresher;
        this.isInherited = isInherited;
        this.init();
    }

    private void init() {
        int x = 0;
        this.numberValueField = new StdJBigDecimalField();
        this.numberValueField.setName("piValue");
        this.numberValueField.addValueChangeListener((StdUIValueChangeListener & Serializable)e -> {
            if (this.isUserAction) {
                this.setBigDecimalValueInternal((BigDecimal)e.getValue());
                this.listeners.forEach(listener -> listener.valueChanged(new StdUIValueChangeEvent((StdUIField)this, (Serializable)this.value)));
            }
        });
        this.stringValueField = new StdJTextField();
        StdUIButtonDescriptor descriptor = StdUIButtonDescriptor.fromIcon(null, (String)"FORM").withTooltip(StdSpringUtil.getMessage((String)"PI_FORM_OPEN", (Object[])new Object[0])).onCLick(arg_0 -> this.openFormDialog(arg_0));
        this.openFormButton = new StdJButton();
        this.openFormButton.setDescriptor(descriptor);
        this.add((Component)this.stringValueField, (Object)new StdJGBC(x, 0).setWeight(100.0, 0.0).setFill(2));
        this.add((Component)this.numberValueField, (Object)new StdJGBC(x++, 0).setWeight(100.0, 0.0).setFill(2));
        if (this.inheritedValueRefresher != null) {
            this.clearButton = new StdJButton();
            this.clearButton.setDescriptor(StdUIButtonDescriptor.fromIcon(null, (String)"REMOVE").withTooltip(StdSpringUtil.getMessage((String)"MISSION_PROFILE_CLEAR", (Object[])new Object[0])).onCLick(b -> this.inheritedValueRefresher.getSetupInheritedValue().accept(this)));
            this.add((Component)this.clearButton, (Object)new StdJGBC(x++, 0).setFill(0).setWeight(0.0, 0.0));
        }
        this.add((Component)this.openFormButton, (Object)new StdJGBC(x, 0).setWeight(0.0, 0.0).setFill(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(PiDTO value) {
        this.value = value;
        try {
            this.isUserAction = false;
            if (value != null) {
                FidesExpression expressionValue = value.getValue();
                if (expressionValue != null) {
                    if (Boolean.TRUE.equals(value.getIsFixed())) {
                        this.stringValueField.setValue((Serializable)((Object)value.getValue().getExpression()));
                    } else {
                        double piDoubleVal = Double.parseDouble(value.getValue().getExpression());
                        this.numberValueField.setValue((Serializable)StdMathUtil.toBigDecimal((Double)piDoubleVal));
                    }
                } else {
                    this.stringValueField.setValue(null);
                    this.numberValueField.setValue(null);
                }
            }
            this.refreshUI();
            this.listeners.forEach(listener -> listener.valueChanged(new StdUIValueChangeEvent((StdUIField)this, (Serializable)value)));
        }
        finally {
            this.isUserAction = true;
        }
    }

    public PiDTO getValue() {
        if (this.value != null && Boolean.FALSE.equals(this.value.getIsFixed())) {
            this.setBigDecimalValueInternal((BigDecimal)this.numberValueField.getValue());
        }
        if (this.value != null && this.value.getValue() == null) {
            return null;
        }
        return this.value;
    }

    private void setBigDecimalValueInternal(BigDecimal numberValue) {
        FidesExpression expressionValue = null;
        if (numberValue != null) {
            expressionValue = FidesExpression.of((String)String.valueOf(numberValue), (FidesParamCode[])new FidesParamCode[0]);
        }
        this.value.setValue(expressionValue);
    }

    public void refreshUI() {
        if (this.value != null && Boolean.TRUE.equals(this.value.getIsFixed())) {
            this.stringValueField.setVisible(true);
            this.numberValueField.setVisible(false);
        } else {
            this.stringValueField.setVisible(false);
            this.numberValueField.setVisible(true);
        }
        if (this.isInherited) {
            this.numberValueField.setForeground(Color.GRAY);
            this.stringValueField.setForeground(Color.GRAY);
        } else {
            this.numberValueField.setForeground(UIManager.getColor("TextField.foreground"));
            this.stringValueField.setForeground(UIManager.getColor("TextField.foreground"));
        }
        if (this.readOnly || this.value == null || Boolean.TRUE.equals(this.value.getIsFixed())) {
            this.setReadOnly(true);
        } else {
            this.numberValueField.setReadOnly(this.value.getIsComputed().booleanValue());
            this.stringValueField.setReadOnly(this.value.getIsComputed().booleanValue());
        }
        this.openFormButton.setVisible(this.value != null && Boolean.FALSE.equals(this.value.getIsFixed()) && this.value.getType().isHasForm());
        this.openFormButton.setEnabled(!this.readOnly);
        this.numberValueField.refreshUI();
        this.stringValueField.refreshUI();
        this.refreshClearButton();
        super.refreshUI();
    }

    private void refreshClearButton() {
        if (this.clearButton != null) {
            this.clearButton.setVisible(this.value != null && this.value.getValue() != null && !this.isInherited && !this.readOnly && this.inheritedValueRefresher.getHasInheritedValue().test(this));
        }
    }

    public void setInherited(boolean inherited) {
        this.isInherited = inherited;
        super.refreshUI();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.numberValueField.setReadOnly(readOnly);
        this.stringValueField.setReadOnly(readOnly);
        this.refreshClearButton();
    }

    private void openFormDialog(StdUIButton stdUIButton) {
        if (this.value.getFormCode() != null) {
            if (this.piDialog == null) {
                this.piDialog = new PiDialogProxy((StdUIComponent)stdUIButton, StdSpringUtil.getMessage((String)this.value.getFormCode().toUpperCase(), (Object[])new Object[0]));
                this.piDialog.addCloseListener(event -> this.setValue((PiDTO)this.piDialog.getEntity()));
            }
            this.piDialog.setEntity(this.value);
            this.piDialog.setReadOnly(this.readOnly);
            this.piDialog.refreshUI();
            this.piDialog.open();
        } else {
            LOGGER.warn("No form found for this Pi", new Object[0]);
            StdUINotificationManager.showErrorNotification((String)"No form found for this Pi");
        }
    }

    public StdListenerRegistration addValueChangeListener(StdUIValueChangeListener<PiDTO> listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }

    public void setTooltip(String tooltip) {
        this.numberValueField.setTooltip(tooltip);
    }

    public String getTooltip() {
        return this.numberValueField.getTooltip();
    }

    public void setErrorMessage(String errorMessage) {
        this.numberValueField.setErrorMessage(errorMessage);
    }

    public void clearErrorMessage() {
        this.numberValueField.clearErrorMessage();
    }

    public boolean hasError() {
        return this.numberValueField.hasError();
    }

    public void setLabelProvider(StdValueProvider<PiDTO, String> labelProvider) {
        if (labelProvider != null) {
            this.numberValueField.setLabelProvider((StdValueProvider & Serializable)val -> (String)labelProvider.apply((Object)this.getValue()));
        }
    }

    public void setTooltipProvider(StdValueProvider<PiDTO, String> tooltipProvider) {
        if (tooltipProvider != null) {
            this.numberValueField.setTooltipProvider((StdValueProvider & Serializable)val -> (String)tooltipProvider.apply((Object)this.getValue()));
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

