/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.consumer;

import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.jpa.StdQueryDTO;
import com.satodev.utils.exception.StdApplException;
import eu.imdr.fides.api.controller.BOMItemController;
import eu.imdr.fides.consumer.BOMItemConsumer;
import eu.imdr.fides.model.DocumentDTO;
import eu.imdr.fides.model.FidesEntityDTO;
import eu.imdr.fides.model.bom.BOMFidesItemDTO;
import eu.imdr.fides.model.bom.BOMItemDTO;
import eu.imdr.fides.model.bom.ProductDTO;
import java.util.List;

public class BomItemDesktopConsumer
implements BOMItemConsumer {
    private final BOMItemController controller = (BOMItemController)StdSpringUtil.getBean(BOMItemController.class, (Object[])new Object[0]);

    public ProductDTO getNewProduct(DocumentDTO document) {
        return this.controller.getNewProduct(document.getId());
    }

    public Long countProducts(DocumentDTO document, StdQueryDTO queryDTO) throws StdApplException {
        return this.controller.countProducts(document.getId(), queryDTO);
    }

    public List<ProductDTO> getProducts(DocumentDTO document, StdQueryDTO queryDTO) throws StdApplException {
        return this.controller.getProducts(document.getId(), queryDTO);
    }

    public ProductDTO saveProduct(ProductDTO dto) throws StdApplException {
        return this.controller.saveProduct(dto);
    }

    public Long countFidesItems(Long productId, BOMFidesItemDTO parentItem, StdQueryDTO queryDTO) throws StdApplException {
        return this.controller.countFidesItems(productId, parentItem, queryDTO);
    }

    public List<BOMFidesItemDTO> getFidesItems(Long productId, BOMFidesItemDTO parentItem, StdQueryDTO queryDTO) throws StdApplException {
        return this.controller.getFidesItems(productId, parentItem, queryDTO);
    }

    public BOMFidesItemDTO getFidesItem(Long id) throws StdApplException {
        return this.controller.getFidesItem(id);
    }

    public BOMFidesItemDTO getFidesItemByExternalId(ProductDTO product, Long externalId) throws StdApplException {
        return this.controller.getFidesItemByExternalId(product.getId(), externalId);
    }

    public Long countAllFidesItems(Long productId, BOMFidesItemDTO parentItem, StdQueryDTO queryDTO) throws StdApplException {
        return this.controller.countAllFidesItems(productId, parentItem != null ? parentItem.getId() : null, queryDTO);
    }

    public List<BOMFidesItemDTO> getAllFidesItems(Long productId, BOMFidesItemDTO parentItem, StdQueryDTO queryDTO) throws StdApplException {
        return this.controller.getAllFidesItems(productId, parentItem != null ? parentItem.getId() : null, queryDTO);
    }

    public BOMFidesItemDTO saveFidesItem(BOMFidesItemDTO dto) throws StdApplException {
        return this.controller.saveFidesItem(dto);
    }

    public void deleteFidesItem(BOMFidesItemDTO dto) throws StdApplException {
        this.controller.deleteFidesItem(dto);
    }

    public boolean copyInFidesItem(BOMItemDTO parentEntity, List<BOMFidesItemDTO> entitiesToCopy) throws StdApplException {
        Long parentProductId = null;
        Long parentFidesItemId = null;
        if (parentEntity instanceof ProductDTO) {
            parentProductId = parentEntity.getId();
        } else if (parentEntity instanceof BOMFidesItemDTO) {
            BOMFidesItemDTO parentFidesItem = (BOMFidesItemDTO)parentEntity;
            parentProductId = parentFidesItem.getParentProductId();
            parentFidesItemId = parentFidesItem.getId();
        }
        if (parentProductId != null || parentFidesItemId != null) {
            List<Long> entityIdsToCopy = entitiesToCopy.stream().map(FidesEntityDTO::getId).toList();
            this.controller.copyInFidesItem(parentProductId, parentFidesItemId, entityIdsToCopy);
            return true;
        }
        return false;
    }
}

