/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.consumer;

import com.satodev.rest.DataImportConsumer;
import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.jpa.StdQueryDTO;
import com.satodev.spring.model.dto.DataImportDTO;
import com.satodev.utils.exception.StdApplException;
import eu.imdr.fides.api.controller.DataImportController;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class DataImportDesktopConsumer
implements DataImportConsumer {
    private final DataImportController controller = (DataImportController)StdSpringUtil.getBean(DataImportController.class, (Object[])new Object[0]);

    public DataImportDTO getBy(Long id) throws StdApplException {
        return this.controller.getDataImportBy(id);
    }

    public List<DataImportDTO> getAllBy(String importType, StdQueryDTO query) throws StdApplException {
        return this.controller.getAllDataImportBy(importType, query);
    }

    public Long count(String importType) throws StdApplException {
        return this.controller.countDataImports(importType);
    }

    public DataImportDTO save(DataImportDTO dataImport) throws StdApplException, IOException {
        String log = dataImport.getImportLog();
        dataImport.setImportLog(null);
        DataImportDTO newDataImport = this.controller.saveDataImport(dataImport);
        newDataImport = this.saveLog(newDataImport, log);
        dataImport.setImportLog(log);
        return newDataImport;
    }

    public String loadLog(DataImportDTO dataImport) throws StdApplException, IOException {
        String logFilePath;
        Path logPath;
        if (dataImport.getLogFilePath() != null && Files.exists(logPath = Path.of(logFilePath = StdSpringUtil.getPrivateResourcePath() + "/import/" + dataImport.getLogFilePath(), new String[0]), new LinkOption[0])) {
            return Files.readString(logPath, StandardCharsets.UTF_8);
        }
        return null;
    }

    public DataImportDTO saveLog(DataImportDTO dataImport, String log) throws StdApplException, IOException {
        if (log != null && dataImport.getLogFilePath() != null) {
            String logFilePath = StdSpringUtil.getPrivateResourcePath() + "/import/" + dataImport.getLogFilePath();
            Files.writeString(Path.of(logFilePath, new String[0]), (CharSequence)log, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        dataImport.setImportLog(log);
        return dataImport;
    }

    public void clean(DataImportDTO dataImport) throws StdApplException {
        this.controller.cleanDataImport(dataImport);
    }

    public void delete(DataImportDTO dataImport) throws StdApplException {
        this.controller.deleteDataImport(dataImport);
    }
}

