/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.consumer;

import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.jpa.StdQueryDTO;
import com.satodev.utils.exception.StdApplException;
import eu.imdr.fides.api.controller.FamilyController;
import eu.imdr.fides.constants.MacroFamily;
import eu.imdr.fides.consumer.FamilyConsumer;
import eu.imdr.fides.model.DocumentDTO;
import eu.imdr.fides.model.FidesEntityDTO;
import eu.imdr.fides.model.bom.BOMFidesItemDTO;
import eu.imdr.fides.model.bom.ItemParamAssocDTO;
import eu.imdr.fides.model.bom.ItemParamValueDTO;
import eu.imdr.fides.model.family.CustomFamilyDTO;
import eu.imdr.fides.model.family.FamilyDTO;
import eu.imdr.fides.model.family.StandardFamilyDTO;
import eu.imdr.fides.model.mp.MPPhaseDTO;
import eu.imdr.fides.model.referential.param.FidesParamDTO;
import java.util.List;

public class FamilyDesktopConsumer
implements FamilyConsumer {
    private final FamilyController familyController = (FamilyController)StdSpringUtil.getBean(FamilyController.class, (Object[])new Object[0]);

    public List<FamilyDTO> getFamiliesBy(MacroFamily macroFamily) {
        return this.familyController.getFamiliesBy(macroFamily);
    }

    public List<StandardFamilyDTO> getAllStandardFamilies() throws StdApplException {
        return this.familyController.getAllStandardFamilies();
    }

    public List<StandardFamilyDTO> getStandardFamiliesBy(MacroFamily macroFamily) throws StdApplException {
        return this.familyController.getStandardFamiliesBy(macroFamily);
    }

    public StandardFamilyDTO getStandardFamilyByFamilyCode(String familyCode) throws StdApplException {
        return this.familyController.getStandardFamilyByFamilyCode(familyCode);
    }

    public Long countCustomFamilies(DocumentDTO documentDTO, StdQueryDTO queryDTO) throws StdApplException {
        return this.familyController.countCustomFamilies(documentDTO.getId(), queryDTO);
    }

    public List<CustomFamilyDTO> getCustomFamiliesBy(DocumentDTO documentDTO, StdQueryDTO queryDTO) throws StdApplException {
        return this.familyController.getCustomFamilies(documentDTO.getId(), queryDTO);
    }

    public CustomFamilyDTO saveCustomFamily(CustomFamilyDTO customFamilyDTO, Boolean copy) throws StdApplException {
        return this.familyController.saveCustomFamily(customFamilyDTO, copy);
    }

    public void deleteCustomFamily(CustomFamilyDTO customFamilyDTO) throws StdApplException {
        this.familyController.deleteCustomFamily(customFamilyDTO);
    }

    public boolean copyCustomFamilies(DocumentDTO document, List<CustomFamilyDTO> familiesToCopy) throws StdApplException {
        return this.familyController.copyCustomFamilies(document.getId(), familiesToCopy.stream().map(FidesEntityDTO::getId).toList());
    }

    public ItemParamValueDTO getParamValue(BOMFidesItemDTO bomFidesItem, FamilyDTO family, FidesParamDTO param, MPPhaseDTO mpPhase) throws StdApplException {
        return this.familyController.getParamValue(bomFidesItem.getId(), family.getId(), param.getCode(), mpPhase != null ? mpPhase.getId() : null);
    }

    public List<ItemParamValueDTO> getParamValues(BOMFidesItemDTO item, FamilyDTO family) throws StdApplException {
        return this.familyController.getParamValues(item != null ? item.getId() : null, family != null ? family.getId() : null);
    }

    public List<ItemParamValueDTO> getParamValues(List<BOMFidesItemDTO> items) throws StdApplException {
        return this.familyController.getParamValues(items);
    }

    public void saveParamValues(BOMFidesItemDTO item, List<ItemParamValueDTO> paramValues) throws StdApplException {
        this.familyController.saveParamValues(item.getId(), paramValues);
    }

    public ItemParamValueDTO saveParamValue(ItemParamValueDTO paramValue) throws StdApplException {
        return this.familyController.saveParamValue(paramValue);
    }

    public List<ItemParamAssocDTO> getParamAssocs(FamilyDTO family) throws StdApplException {
        return this.familyController.getParamAssocs(family != null ? family.getId() : null);
    }

    public List<ItemParamAssocDTO> saveParamAssocs(FamilyDTO family, List<ItemParamAssocDTO> items) throws StdApplException {
        return this.familyController.saveItemParams(family, items);
    }
}

