/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.consumer;

import com.satodev.oneui.StdUINotificationManager;
import com.satodev.spring.StdSpringUtil;
import com.satodev.utils.exception.StdApplException;
import com.satodev.utils.log.StdLogger;
import eu.imdr.fides.api.controller.IOController;
import eu.imdr.fides.consumer.IOConsumer;
import eu.imdr.fides.exception.FidesAuthenticityException;
import eu.imdr.fides.model.DocumentDTO;
import eu.imdr.fides.model.bom.BOMFidesItemDTO;
import eu.imdr.fides.model.bom.ProductDTO;
import eu.imdr.fides.model.family.CustomFamilyDTO;
import eu.imdr.fides.model.mp.MissionProfileDTO;
import eu.imdr.fides.uicontroller.file.FidesFileUIController;
import eu.imdr.fides.uicontroller.worksheet.FidesWorkSheetManager;
import java.util.List;

public class IODesktopConsumer
implements IOConsumer {
    private final IOController ioController = (IOController)StdSpringUtil.getBean(IOController.class, (Object[])new Object[0]);
    private final FidesFileUIController fileUIController = (FidesFileUIController)StdSpringUtil.getBean(FidesFileUIController.class, (Object[])new Object[0]);
    private static final StdLogger logger = StdLogger.get(IODesktopConsumer.class);

    public void writeDocument(DocumentDTO document, String filePath) throws StdApplException {
        this.ioController.writeDocument(document, filePath);
    }

    public DocumentDTO readDocument(DocumentDTO document, String filePath) throws StdApplException {
        DocumentDTO doc = this.ioController.readDocument(document, filePath);
        try {
            this.ioController.checkDocument(filePath);
        }
        catch (FidesAuthenticityException e) {
            StdUINotificationManager.showWarning((StdLogger)logger, (String)(StdSpringUtil.getMessage((String)"FILE_AUTHENTICATION_FAILED", (Object[])new Object[0]) + " : " + e.getMessage()), null);
        }
        List errorMsg = this.ioController.checkCustomFamilies(doc);
        if (!errorMsg.isEmpty()) {
            for (String error : errorMsg) {
                StdUINotificationManager.showWarning((StdLogger)logger, (String)(StdSpringUtil.getMessage((String)"CUSTOM_FAMILY_AUTHENTICATION_FAILED", (Object[])new Object[0]) + " : " + error), null);
            }
        }
        return doc;
    }

    public String getDocumentSignature(DocumentDTO document) throws StdApplException {
        return this.ioController.getDocumentSignature(document);
    }

    public void writeMissionProfiles(List<MissionProfileDTO> missionProfiles) throws StdApplException {
        this.fileUIController.saveFileAsPartialFile(null, filePath -> {
            this.ioController.writeMissionProfiles(missionProfiles, filePath);
            return null;
        });
    }

    public void writeCustomFamilies(List<CustomFamilyDTO> customFamilies) throws StdApplException {
        this.fileUIController.saveFileAsPartialFile(null, filePath -> {
            this.ioController.writeCustomFamilies(customFamilies, filePath);
            return null;
        });
    }

    public void writeBomItem(List<BOMFidesItemDTO> items) throws StdApplException {
        this.fileUIController.saveFileAsPartialFile(null, filePath -> {
            this.ioController.writeBomItems(items, filePath);
            return null;
        });
    }

    public void importMissionProfiles() {
        DocumentDTO currentDoc = FidesWorkSheetManager.getSelectedDocument();
        this.fileUIController.simpleChooseAndLoadPartialFile(null, filePath -> this.ioController.readMissionProfiles(currentDoc, filePath));
    }

    public void importCustomFamilies() {
        DocumentDTO currentDoc = FidesWorkSheetManager.getSelectedDocument();
        this.fileUIController.simpleChooseAndLoadPartialFile(null, filePath -> this.ioController.readCustomFamilies(currentDoc, filePath));
    }

    public void importBomItem(BOMFidesItemDTO origin) {
        DocumentDTO currentDoc = FidesWorkSheetManager.getSelectedDocument();
        ProductDTO productDTO = FidesWorkSheetManager.getParentProduct();
        this.fileUIController.simpleChooseAndLoadPartialFile(null, filePath -> this.ioController.readBomItem(currentDoc, filePath, origin, productDTO));
    }
}

