/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.consumer;

import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.jpa.StdQueryDTO;
import com.satodev.utils.exception.StdApplException;
import eu.imdr.fides.api.controller.ResultController;
import eu.imdr.fides.consumer.ResultConsumer;
import eu.imdr.fides.item.LawKey;
import eu.imdr.fides.item.ResultReportItemDTO;
import eu.imdr.fides.model.bom.BOMFidesItemDTO;
import eu.imdr.fides.model.bom.ProductDTO;
import eu.imdr.fides.model.result.ResultDTO;
import eu.imdr.fides.model.result.ResultFidesDeviationDTO;
import eu.imdr.fides.model.result.ResultItemValueDTO;
import eu.imdr.fides.model.result.ResultPhaseValueDTO;
import java.math.BigDecimal;
import java.util.List;

public class ResultDesktopConsumer
implements ResultConsumer {
    private final ResultController controller = (ResultController)StdSpringUtil.getBean(ResultController.class, (Object[])new Object[0]);

    public ResultDTO getResultBy(ProductDTO product) throws StdApplException {
        return this.controller.getResultBy(product);
    }

    public ResultDTO setResultUpToDate(ResultDTO result, boolean b) throws StdApplException {
        return this.controller.setResultUpToDate(result.getId(), b);
    }

    public void deleteResult(ResultDTO result) throws StdApplException {
        if (result != null) {
            this.controller.deleteResult(String.valueOf(result.getId()));
        }
    }

    public Long countResultItemsBy(ResultDTO result, StdQueryDTO query) throws StdApplException {
        return this.controller.countResultItemBy(result.getId(), query);
    }

    public List<ResultItemValueDTO> getResultItemsBy(ResultDTO result, StdQueryDTO query) throws StdApplException {
        return this.controller.getResultItemsBy(result.getId(), query);
    }

    public Long countResultPhasesBy(ResultItemValueDTO resultItemValue, StdQueryDTO query) throws StdApplException {
        return this.controller.countResultPhaseByResultItem(resultItemValue.getId(), query);
    }

    public List<ResultPhaseValueDTO> getResultPhasesBy(ResultItemValueDTO resultItemValue, StdQueryDTO query) throws StdApplException {
        return this.controller.getResultPhaseByResultItem(resultItemValue.getId(), query);
    }

    public List<BOMFidesItemDTO> getFidesItemsBy(List<Long> resultItemIds) throws StdApplException {
        return this.controller.getFidesItemsByResultIds(resultItemIds);
    }

    public List<LawKey> getLawKeysBy(ResultDTO result) throws StdApplException {
        return this.controller.getLawKeys(result.getId());
    }

    public Long countResultDeviationBy(ResultDTO result, StdQueryDTO query) {
        return this.controller.countResultFidesDeviationBy(result.getId(), query);
    }

    public List<ResultFidesDeviationDTO> getResultDeviationsBy(ResultDTO result, StdQueryDTO query) {
        return this.controller.getResultFidesDeviation(result.getId(), query);
    }

    public BigDecimal getStressTotal(ResultItemValueDTO resultItemValue, LawKey lawKey) {
        return this.controller.getStressTotal(resultItemValue.getId(), lawKey.getLawNameKey(), lawKey.getLawType());
    }

    public BigDecimal getLambdaPhaseTotal(ResultItemValueDTO resultItemValue, String lambdaField) {
        return this.controller.getLambdaPhaseTotal(resultItemValue.getId(), lambdaField);
    }

    public BigDecimal getStressTotalByResult(ResultDTO result, LawKey lawKey) {
        return this.controller.getStressTotalByResult(result.getId(), lawKey.getLawNameKey(), lawKey.getLawType());
    }

    public List<ResultReportItemDTO> getResultReportItemBy(ResultDTO result) {
        return this.controller.getResultReportItemByResult(result.getId());
    }
}

