/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.ui.field;

import com.satodev.desktop.ui.button.StdJButton;
import com.satodev.desktop.ui.field.combobox.StdJComboBox;
import com.satodev.desktop.ui.panel.StdJGBC;
import com.satodev.desktop.ui.panel.StdJPanel;
import com.satodev.oneui.StdUINotificationManager;
import com.satodev.oneui.button.StdUIButton;
import com.satodev.oneui.button.StdUIButtonDescriptor;
import com.satodev.oneui.form.StdUIValueChangeListener;
import com.satodev.oneui.table.StdValueProvider;
import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.util.StdListenerRegistration;
import com.satodev.utils.log.StdLogger;
import eu.imdr.fides.constants.MacroFamily;
import eu.imdr.fides.consumer.FamilyConsumer;
import eu.imdr.fides.model.family.FamilyDTO;
import eu.imdr.fides.model.family.StandardFamilyDTO;
import eu.imdr.fides.ui.family.UIFamilyField;
import eu.imdr.fides.ui.panel.FamilyImgDialog;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFamilyField<T extends FamilyDTO>
extends StdJPanel
implements UIFamilyField<T> {
    private static final StdLogger logger = StdLogger.get(AbstractFamilyField.class);
    protected static final FamilyConsumer familyConsumer = (FamilyConsumer)StdSpringUtil.getBean((String)"familyConsumer", (Object[])new Object[0]);
    private MacroFamily macroFamily;
    private StdJComboBox<T> field;
    private StdJButton viewDescriptionButton;
    private Path imagePath;
    private boolean isUserAction = true;

    protected AbstractFamilyField(MacroFamily macroFamily) {
        this.macroFamily = macroFamily;
    }

    protected void init() {
        this.field = new StdJComboBox();
        this.field.setLabelProvider(FamilyDTO::toHtml);
        this.field.setTooltipProvider(FamilyDTO::getDescription);
        this.field.addValueChangeListener((StdUIValueChangeListener & Serializable)e -> {
            if (this.isUserAction) {
                this.isUserAction = false;
                try {
                    this.setValue((FamilyDTO)e.getValue());
                }
                finally {
                    this.isUserAction = true;
                }
            }
        });
        this.add((Component)this.field, (Object)new StdJGBC(0, 0).setFill(2).setWeight(100.0, 0.0));
        this.viewDescriptionButton = new StdJButton();
        this.viewDescriptionButton.setDescriptor(StdUIButtonDescriptor.fromIcon(null, (String)"DETAIL").withTooltip(StdSpringUtil.getMessage((String)"BOM_FIDES_ITEM_FAMILY_DESCRIPTION", (Object[])new Object[0])).onCLick(arg_0 -> this.openDialog(arg_0)));
        this.add((Component)this.viewDescriptionButton, (Object)new StdJGBC(1, 0).setFill(0).setWeight(0.0, 0.0));
    }

    public void setMacroFamily(MacroFamily macroFamily) {
        this.macroFamily = macroFamily;
        this.refreshUI();
    }

    public void refreshUI() {
        List families = new ArrayList();
        if (this.macroFamily != null) {
            try {
                families = this.fetchFamilies(this.macroFamily);
            }
            catch (Exception ex) {
                StdUINotificationManager.showError((StdLogger)logger, (String)("Unable to load families from macro-family: " + this.macroFamily.getLabel()), (Exception)ex);
            }
        }
        this.field.setItems(families);
        if (families.size() == 1) {
            List finalFamilies = families;
            EventQueue.invokeLater(() -> this.field.setValue((Serializable)((FamilyDTO)finalFamilies.get(0))));
        }
        super.refreshUI();
    }

    protected abstract List<T> fetchFamilies(MacroFamily var1) throws Exception;

    private void openDialog(StdUIButton button) {
        FamilyImgDialog descriptionDialog = new FamilyImgDialog(this.imagePath, Integer.valueOf(1000), Integer.valueOf(850));
        descriptionDialog.open();
    }

    public void setReadOnly(boolean readOnly) {
        this.field.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.field.isReadOnly();
    }

    public void setValue(T value) {
        this.field.setValue(value);
        if (value instanceof StandardFamilyDTO) {
            StandardFamilyDTO standardFamily = (StandardFamilyDTO)value;
            this.imagePath = Path.of(StdSpringUtil.getProperty((String)"std.img.path") + standardFamily.getCode().toLowerCase() + ".png", new String[0]).toAbsolutePath().normalize();
            logger.debug("Image path: " + this.imagePath, new Object[0]);
        } else {
            this.imagePath = null;
        }
        this.viewDescriptionButton.setEnabled(this.imagePath != null);
    }

    public T getValue() {
        return (T)((FamilyDTO)this.field.getValue());
    }

    public StdListenerRegistration addValueChangeListener(StdUIValueChangeListener<T> listener) {
        return this.field.addValueChangeListener(listener);
    }

    public void setTooltip(String tooltip) {
        this.field.setTooltip(tooltip);
    }

    public String getTooltip() {
        return this.field.getTooltip();
    }

    public void setErrorMessage(String errorMessage) {
        this.field.setErrorMessage(errorMessage);
    }

    public void clearErrorMessage() {
        this.field.clearErrorMessage();
    }

    public boolean hasError() {
        return this.field.hasError();
    }

    public void setLabelProvider(StdValueProvider<T, String> labelProvider) {
    }

    public void setTooltipProvider(StdValueProvider<T, String> tooltipProvider) {
    }
}

