/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.ui.field;

import com.satodev.desktop.ui.component.StdJLazyDescriptionComponent;
import com.satodev.desktop.ui.dialog.StdJAutocompletePopup;
import com.satodev.desktop.ui.field.textfield.StdJAbstractTextField;
import com.satodev.desktop.ui.panel.StdJGBC;
import com.satodev.desktop.ui.panel.StdJPanel;
import com.satodev.oneui.StdUINotificationManager;
import com.satodev.oneui.form.StdUIField;
import com.satodev.oneui.form.StdUIValueChangeListener;
import com.satodev.oneui.table.StdValueProvider;
import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.util.StdListenerRegistration;
import com.satodev.utils.exception.StdApplException;
import com.satodev.utils.log.StdLogger;
import eu.imdr.fides.constants.FidesParamCode;
import eu.imdr.fides.consumer.FidesParamConsumer;
import eu.imdr.fides.item.FidesExpression;
import eu.imdr.fides.model.referential.param.FidesParamDTO;
import eu.imdr.fides.ui.field.FidesExpressionField;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FidesExpressionField
extends StdJPanel
implements StdUIField<FidesExpression> {
    private static final StdLogger logger = StdLogger.get(FidesExpressionField.class);
    private StdJAutocompletePopup<FidesParamDTO> dialog;
    private List<FidesParamDTO> fidesParamDTOList;
    private int insertPosition = 0;
    private StdJAbstractTextField<FidesExpression> textField;
    private StdJLazyDescriptionComponent helpButton;
    private final transient FidesParamConsumer consumer = (FidesParamConsumer)StdSpringUtil.getBean((String)"fidesParamConsumer", (Object[])new Object[0]);

    public FidesExpressionField() {
        try {
            this.fidesParamDTOList = this.consumer.getAllParams();
        }
        catch (StdApplException ex) {
            StdUINotificationManager.showError((StdLogger)logger, (String)"Unable to fetch all FIDES params", (Exception)((Object)ex));
            this.fidesParamDTOList = new ArrayList();
        }
        this.helpButton = new StdJLazyDescriptionComponent(Integer.valueOf(530), Integer.valueOf(650), "QUESTION_MARK");
        this.helpButton.setTxtSupplier(() -> StdSpringUtil.getMessage((String)"FIDES_EXPRESSION_INFO", (Object[])new Object[0]));
        this.helpButton.refreshUI();
        this.textField = new /* Unavailable Anonymous Inner Class!! */;
        this.add((Component)this.textField, (Object)new StdJGBC(0, 0).setWeight(100.0, 0.0).setFill(2));
        this.add((Component)this.helpButton, (Object)new StdJGBC(1, 0).setWeight(0.0, 0.0));
        this.dialog = new StdJAutocompletePopup(StdSpringUtil.getMessage((String)"FIDES_PARAM_POPUP", (Object[])new Object[0]), this.fidesParamDTOList, fidesParamDTO -> {
            FidesExpression currentExpression = this.getValue();
            String newFidesExpression = "_" + fidesParamDTO.getCode();
            if (currentExpression != null) {
                String val = currentExpression.getExpression();
                String[] splitValues = new String[]{val.substring(0, this.insertPosition), val.substring(this.insertPosition)};
                newFidesExpression = splitValues[0] + " " + newFidesExpression + " " + splitValues[1];
            }
            this.setValue(FidesExpression.of((String)newFidesExpression, (FidesParamCode[])new FidesParamCode[0]));
            this.dialog.close();
        }, arg_0 -> this.filterFidesParam(arg_0));
        this.dialog.getAutoCompleteList().setIconProvider(arg_0 -> this.getFidesParamIcon(arg_0));
        this.dialog.getAutoCompleteList().setLabelProvider(arg_0 -> this.getFidesParamLabel(arg_0));
        this.textField.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private List<FidesParamDTO> filterFidesParam(String filter) {
        ArrayList<FidesParamDTO> filteredList = new ArrayList<FidesParamDTO>();
        for (FidesParamDTO fidesParamDTO : this.fidesParamDTOList) {
            if (!fidesParamDTO.getCode().contains(filter)) continue;
            filteredList.add(fidesParamDTO);
        }
        return filteredList;
    }

    private String getFidesParamIcon(FidesParamDTO fidesParam) {
        return switch (3.$SwitchMap$eu$imdr$fides$constants$FidesParamValueType[fidesParam.getValueType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> "NUMERIC";
            case 2 -> "LIST";
            case 3 -> "BOOLEAN";
            case 4 -> "TEXT";
        };
    }

    private String getFidesParamLabel(FidesParamDTO fidesParam) {
        String color = switch (3.$SwitchMap$eu$imdr$fides$constants$FidesParamType[fidesParam.getType().ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> "#4682b4";
            case 2 -> "purple";
            case 3 -> "orange";
            case 4 -> "green";
            case 5 -> "red";
        };
        String htmlLabel = "<html><span style=\"color:" + color + "\">   " + fidesParam.getCode() + "</span>";
        String unit = fidesParam.getUnit();
        if (unit != null && !unit.isBlank()) {
            htmlLabel = htmlLabel + "<span style=\"color:gray\"> [" + fidesParam.getUnit() + "]</span>";
        }
        htmlLabel = htmlLabel + "</html>";
        return htmlLabel;
    }

    public void setReadOnly(boolean readOnly) {
        this.textField.setReadOnly(readOnly);
    }

    public boolean isReadOnly() {
        return this.textField.isReadOnly();
    }

    public void setValue(FidesExpression value) {
        this.textField.setValue((Serializable)value);
    }

    public FidesExpression getValue() {
        return (FidesExpression)this.textField.getValue();
    }

    public StdListenerRegistration addValueChangeListener(StdUIValueChangeListener<FidesExpression> listener) {
        return this.textField.addValueChangeListener(listener);
    }

    public void setTooltip(String tooltip) {
        this.textField.setTooltip(tooltip);
    }

    public String getTooltip() {
        return this.textField.getTooltip();
    }

    public void setErrorMessage(String errorMessage) {
        this.textField.setErrorMessage(errorMessage);
    }

    public void clearErrorMessage() {
        this.textField.clearErrorMessage();
    }

    public boolean hasError() {
        return this.textField.hasError();
    }

    public void setLabelProvider(StdValueProvider<FidesExpression, String> labelProvider) {
        this.textField.setLabelProvider(labelProvider);
    }

    public void setTooltipProvider(StdValueProvider<FidesExpression, String> tooltipProvider) {
        this.textField.setTooltipProvider(tooltipProvider);
    }
}

