/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.ui.field;

import com.satodev.desktop.ui.button.StdJButton;
import com.satodev.desktop.ui.field.combobox.StdJComboBox;
import com.satodev.desktop.ui.panel.StdJGBC;
import com.satodev.desktop.ui.panel.StdJPanel;
import com.satodev.oneui.StdUINotificationManager;
import com.satodev.oneui.button.StdUIButton;
import com.satodev.oneui.button.StdUIButtonDescriptor;
import com.satodev.oneui.component.StdUIComponent;
import com.satodev.oneui.dialog.StdUIEntityFormDialog;
import com.satodev.oneui.dialog.StdUIEntityFormDialogProxy;
import com.satodev.oneui.form.StdUIField;
import com.satodev.oneui.form.StdUIFormFactory;
import com.satodev.oneui.form.StdUIValueChangeListener;
import com.satodev.oneui.table.StdValueProvider;
import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.jpa.StdQueryDTO;
import com.satodev.spring.util.StdListenerRegistration;
import com.satodev.utils.log.StdLogger;
import eu.imdr.fides.consumer.MissionProfileConsumer;
import eu.imdr.fides.model.DocumentDTO;
import eu.imdr.fides.model.mp.MissionProfileDTO;
import eu.imdr.fides.ui.bom.form.BOMInheritedValueRefresher;
import eu.imdr.fides.ui.bom.form.FidesInheritedValueField;
import eu.imdr.fides.ui.mp.form.MissionProfileFormFactory;
import eu.imdr.fides.uicontroller.worksheet.FidesWorkSheetManager;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.List;

public class MissionProfileField
extends StdJPanel
implements StdUIField<MissionProfileDTO>,
FidesInheritedValueField {
    private static final StdLogger logger = StdLogger.get(MissionProfileField.class);
    private final transient MissionProfileConsumer missionProfileConsumer = (MissionProfileConsumer)StdSpringUtil.getBean((String)"missionProfileConsumer", (Object[])new Object[0]);
    private boolean isInherited = false;
    private final BOMInheritedValueRefresher<MissionProfileDTO> inheritedValueRefresher;
    private StdJComboBox<MissionProfileDTO> field;
    private StdJButton clearButton;
    private StdJButton addButton;
    private StdUIEntityFormDialog<MissionProfileDTO> formDialog;
    private MissionProfileDTO value;
    private boolean readOnly;

    public MissionProfileField() {
        this(false, null);
    }

    public MissionProfileField(boolean isInherited) {
        this(isInherited, null);
    }

    public MissionProfileField(boolean isInherited, BOMInheritedValueRefresher<MissionProfileDTO> inheritedValueRefresher) {
        this.inheritedValueRefresher = inheritedValueRefresher;
        this.init();
        this.setInherited(isInherited);
        this.refreshUI();
    }

    public void setInherited(boolean inherited) {
        this.isInherited = inherited;
        if (inherited) {
            this.field.setForeground(Color.GRAY);
        } else {
            this.field.setForeground(Color.BLACK);
        }
        super.refreshUI();
    }

    private void init() {
        int x = 0;
        this.field = new StdJComboBox();
        this.field.setNullValueAllowed(false);
        this.field.addValueChangeListener((StdUIValueChangeListener & Serializable)e -> {
            this.value = (MissionProfileDTO)e.getValue();
            this.refreshClearButton();
        });
        this.add((Component)this.field, (Object)new StdJGBC(x++, 0).setFill(2).setWeight(100.0, 0.0));
        if (this.inheritedValueRefresher != null) {
            this.clearButton = new StdJButton();
            this.clearButton.setDescriptor(StdUIButtonDescriptor.fromIcon(null, (String)"REMOVE").withTooltip(StdSpringUtil.getMessage((String)"MISSION_PROFILE_CLEAR", (Object[])new Object[0])).onCLick(b -> this.inheritedValueRefresher.getSetupInheritedValue().accept(this)));
            this.add((Component)this.clearButton, (Object)new StdJGBC(x++, 0).setFill(0).setWeight(0.0, 0.0));
        }
        this.addButton = new StdJButton();
        this.addButton.setDescriptor(StdUIButtonDescriptor.fromIcon(null, (String)"ADD").withTooltip(StdSpringUtil.getMessage((String)"MISSION_PROFILE_ADD", (Object[])new Object[0])).onCLick(arg_0 -> this.openDialog(arg_0)));
        this.add((Component)this.addButton, (Object)new StdJGBC(x, 0).setFill(0).setWeight(0.0, 0.0));
    }

    public void refreshUI() {
        try {
            DocumentDTO currentDocument = FidesWorkSheetManager.getSelectedDocument();
            List items = this.missionProfileConsumer.getMissionProfilesBy(currentDocument, StdQueryDTO.empty());
            this.field.setItems(items);
        }
        catch (Exception ex) {
            StdUINotificationManager.showError((StdLogger)logger, (String)"Unable to load mission profiles", (Exception)ex);
        }
        super.refreshUI();
    }

    private void refreshClearButton() {
        if (this.clearButton != null) {
            this.clearButton.setVisible(this.value != null && !this.isInherited && !this.readOnly && this.inheritedValueRefresher.getHasInheritedValue().test(this));
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.field.setReadOnly(readOnly);
        this.addButton.setEnabled(!readOnly);
        this.refreshClearButton();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setValue(MissionProfileDTO value) {
        this.value = value;
        this.field.setValue((Serializable)value);
    }

    public MissionProfileDTO getValue() {
        return this.value;
    }

    public StdListenerRegistration addValueChangeListener(StdUIValueChangeListener<MissionProfileDTO> listener) {
        return this.field.addValueChangeListener(listener);
    }

    public void setTooltip(String tooltip) {
        this.field.setTooltip(tooltip);
    }

    public String getTooltip() {
        return this.field.getTooltip();
    }

    public void setErrorMessage(String errorMessage) {
        this.field.setErrorMessage(errorMessage);
    }

    public void clearErrorMessage() {
        this.field.clearErrorMessage();
    }

    public boolean hasError() {
        return this.field.hasError();
    }

    public void setLabelProvider(StdValueProvider<MissionProfileDTO, String> labelProvider) {
        this.field.setLabelProvider(labelProvider);
    }

    public void setTooltipProvider(StdValueProvider<MissionProfileDTO, String> tooltipProvider) {
        this.field.setTooltipProvider(tooltipProvider);
    }

    private void openDialog(StdUIButton button) {
        if (this.formDialog == null) {
            MissionProfileFormFactory formFactory = new MissionProfileFormFactory();
            StdUIEntityFormDialogProxy dialogProxy = new StdUIEntityFormDialogProxy((StdUIComponent)button, StdSpringUtil.getMessage((String)"MISSION_PROFILE_TITLE", (Object[])new Object[0]), (StdUIFormFactory)formFactory, arg_0 -> this.saveMissionProfile(arg_0));
            this.formDialog = (StdUIEntityFormDialog)dialogProxy.getInstance();
        }
        MissionProfileDTO newMissionProfile = new MissionProfileDTO();
        DocumentDTO document = FidesWorkSheetManager.getSelectedDocument();
        newMissionProfile.setDocumentId(document.getId());
        this.formDialog.setEntity((Serializable)newMissionProfile);
        this.formDialog.open();
    }

    private MissionProfileDTO saveMissionProfile(MissionProfileDTO entity) throws Exception {
        MissionProfileDTO savedEntity = this.missionProfileConsumer.saveMissionProfile(entity);
        this.refreshUI();
        this.setValue(savedEntity);
        return savedEntity;
    }
}

