/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.ui.panel;

import com.satodev.desktop.ui.component.StdJImage;
import com.satodev.desktop.ui.component.StdJLabel;
import com.satodev.desktop.ui.panel.StdJGBC;
import com.satodev.desktop.ui.panel.StdJPanel;
import com.satodev.spring.StdSpringUtil;
import com.satodev.utils.date.StdDate;
import com.satodev.utils.log.StdLogger;
import eu.imdr.fides.ui.other.AboutPanel;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import org.springframework.boot.info.BuildProperties;

public class AboutDesktopPanel
extends StdJPanel
implements AboutPanel {
    private static StdLogger logger = StdLogger.get(AboutDesktopPanel.class);
    private static final String SATODEV_LINK = "https://satodev.com/";

    public AboutDesktopPanel() {
        BuildProperties properties = (BuildProperties)StdSpringUtil.getBean(BuildProperties.class, (Object[])new Object[0]);
        StdJImage logo = new StdJImage("images/fides-splash.png", Integer.valueOf(458), Integer.valueOf(111));
        StdJLabel title = new StdJLabel(StdSpringUtil.getMessage((String)"ABOUT_TITLE", (Object[])new Object[0]));
        StdJLabel appVersion = new StdJLabel(StdSpringUtil.getMessage((String)"VERSION", (Object[])new Object[0]) + " " + properties.getVersion());
        StdJLabel pid = new StdJLabel(StdSpringUtil.getMessage((String)"PID", (Object[])new Object[0]) + " " + System.getProperty("PID"));
        StdJLabel releaseDate = new StdJLabel(StdSpringUtil.getMessage((String)"RELEASE", (Object[])new Object[0]) + " " + StdDate.from((Instant)properties.getTime()).format("yyyy-MM-dd HH:mm:ss", true));
        StdJLabel copyright = new StdJLabel(StdSpringUtil.getMessage((String)"COPYRIGHT", (Object[])new Object[0]));
        this.setSizeFull();
        copyright.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        int y = 0;
        this.add((Component)logo, (Object)new StdJGBC(0, 0).setWeight(0.0, 0.0).setFill(0).setInsets(5, 0, 10, 0));
        this.add((Component)title, (Object)new StdJGBC(0, y++).setWeight(1.0, 0.0).setFill(13).setInsets(10, 0, 0, 0));
        this.add((Component)appVersion, (Object)new StdJGBC(0, y++).setWeight(1.0, 0.0).setFill(13).setInsets(10, 0, 0, 0));
        this.add((Component)pid, (Object)new StdJGBC(0, y++).setWeight(1.0, 0.0).setFill(13).setInsets(10, 0, 0, 0));
        this.add((Component)releaseDate, (Object)new StdJGBC(0, y++).setWeight(1.0, 0.0).setFill(13).setInsets(10, 0, 0, 0));
        this.add((Component)copyright, (Object)new StdJGBC(0, y++).setWeight(1.0, 0.0).setFill(13).setInsets(10, 0, 0, 0));
    }

    private static void open(URI uri) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                logger.error("Cannot open hyperlink", (Throwable)e);
            }
        } else {
            logger.error("Hyperlink not supported", new Object[0]);
        }
    }
}

