/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.ui.panel;

import com.satodev.desktop.ui.StdJFrameManager;
import com.satodev.desktop.ui.component.StdJImage;
import com.satodev.desktop.ui.dialog.StdJDialog;
import com.satodev.desktop.ui.panel.StdJGBC;
import com.satodev.desktop.ui.panel.StdJPanel;
import com.satodev.desktop.ui.panel.StdJScrollPanel;
import com.satodev.oneui.StdUI;
import com.satodev.oneui.StdUINotificationManager;
import com.satodev.oneui.StdUIUtil;
import com.satodev.oneui.component.StdUIComponent;
import com.satodev.oneui.dialog.StdUIDialogMode;
import com.satodev.spring.StdSpringUtil;
import com.satodev.utils.log.StdLogger;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FamilyImgDialog
extends StdJDialog {
    private static final StdLogger logger = StdLogger.get(FamilyImgDialog.class);
    private Path imgPath;
    private StdJScrollPanel scrollPanel;
    private StdJImage img;
    private StdJPanel mainPanel;

    public FamilyImgDialog(Path imgPath, Integer width, Integer height) {
        super((StdUIComponent)StdJFrameManager.getInstance().getCurrentWindow());
        this.setDialogSize(width.intValue(), height.intValue());
        this.setModal(false);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.setMode(StdUIDialogMode.MODE_CLOSE);
        this.setTitle(StdSpringUtil.getMessage((String)"FAMILY_IMG_TITLE", (Object[])new Object[0]));
        this.imgPath = imgPath;
        if (Files.exists(imgPath, new LinkOption[0])) {
            try {
                this.img = new StdJImage(imgPath.toFile().toURI().toURL());
            }
            catch (Exception e) {
                logger.error(e.getMessage(), new Object[0]);
            }
        }
        this.mainPanel = new StdJPanel();
        this.scrollPanel = new StdJScrollPanel((Component)this.img);
        this.scrollPanel.setWheelScrollingEnabled(true);
        this.scrollPanel.setHorizontalScrollBarPolicy(31);
        this.mainPanel.add((Component)this.scrollPanel, (Object)new StdJGBC(0, 0).setWeight(100.0, 100.0).setFill(1));
        this.setContent((StdUIComponent)this.mainPanel);
        StdUIUtil.executeOnUI((StdUI)StdUIUtil.getCurrentUI(), () -> this.replaceImg(imgPath));
        this.addComponentListener((ComponentListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openImg() {
        File imgFile = this.imgPath.toFile();
        if (imgFile.exists()) {
            try {
                Desktop.getDesktop().open(imgFile);
            }
            catch (Exception ex) {
                StdUINotificationManager.showError((StdLogger)logger, (String)("Cannot open img " + imgFile.getAbsolutePath()), (Exception)ex);
            }
        } else {
            StdUINotificationManager.showError((StdLogger)logger, (String)("Cannot find img " + imgFile.getAbsolutePath()), null);
        }
    }

    public void replaceImg(Path imgPath) {
        this.imgPath = imgPath;
        this.mainPanel.remove((StdUIComponent)this.scrollPanel);
        if (Files.exists(imgPath, new LinkOption[0]) && this.img != null) {
            try {
                float ratio = (float)(this.getWidth() - 50) / (float)this.img.getWidth();
                int imgNewWidth = Math.round(ratio * (float)this.img.getWidth());
                int imgNewHeight = Math.round(ratio * (float)this.img.getHeight());
                this.scrollPanel = new StdJScrollPanel((Component)new StdJImage(imgPath.toFile().toURI().toURL(), Integer.valueOf(imgNewWidth), Integer.valueOf(imgNewHeight)));
                this.scrollPanel.setWheelScrollingEnabled(true);
                this.scrollPanel.getViewport().setPreferredSize(new Dimension(imgNewWidth + 10, this.getHeight() - 50));
                this.scrollPanel.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
                this.scrollPanel.setHorizontalScrollBarPolicy(31);
                this.add((Component)this.scrollPanel, (Object)new StdJGBC(0, 0).setWeight(100.0, 100.0).setFill(1));
            }
            catch (Exception e) {
                StdUINotificationManager.showError((StdLogger)logger, (String)"Cannot display img", (Exception)e);
            }
        }
    }

    static /* synthetic */ Rectangle access$000(FamilyImgDialog x0) {
        return x0.displayScreen;
    }

    static /* synthetic */ Rectangle access$102(FamilyImgDialog x0, Rectangle x1) {
        x0.displayScreen = x1;
        return x0.displayScreen;
    }
}

