/*
 * Decompiled with CFR 0.152.
 */
package eu.imdr.fides.uicontroller.file;

import com.satodev.desktop.ui.component.StdJFileChooser;
import com.satodev.desktop.ui.util.StdSwingUtil;
import com.satodev.oneui.StdUINotificationManager;
import com.satodev.oneui.component.StdUIComponent;
import com.satodev.spring.StdSpringUtil;
import com.satodev.spring.undoredo.StdUndoRedoManager;
import com.satodev.utils.log.StdLogger;
import eu.imdr.fides.consumer.DocumentConsumer;
import eu.imdr.fides.model.DocumentDTO;
import eu.imdr.fides.uicontroller.file.FidesFileUIController;
import eu.imdr.fides.uicontroller.file.FidesFileUIControllerAction;
import eu.imdr.fides.uicontroller.file.FidesProperties;
import eu.imdr.fides.uicontroller.file.FidesPropertyNames;
import eu.imdr.fides.uicontroller.worksheet.FidesWorkSheetManager;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class FidesFileDesktopUIController
implements FidesFileUIController {
    private static final StdLogger LOGGER = StdLogger.get(FidesFileDesktopUIController.class);
    private static final DocumentConsumer consumer = (DocumentConsumer)StdSpringUtil.getBean((String)"documentConsumer", (Object[])new Object[0]);
    private File lastFile = null;
    private final LinkedList<String> recentFiles = new LinkedList();
    private int maxRecentFilesSize = 10;
    private final FidesProperties fidesProperties = new FidesProperties();

    public FidesFileDesktopUIController() {
        this.maxRecentFilesSize = Integer.parseInt(StdSpringUtil.getProperty((String)"std.files.open.recent.max"));
        String listOfRecentFiles = this.fidesProperties.getProperty(FidesPropertyNames.RECENT_FILES.name());
        if (listOfRecentFiles != null) {
            for (String f : listOfRecentFiles.split(";")) {
                if (this.recentFiles.size() >= this.maxRecentFilesSize) break;
                if (f.isBlank()) continue;
                this.recentFiles.add(f);
            }
        }
    }

    public void newDocument() {
        FidesWorkSheetManager.setDocumentChanged((boolean)false);
        this.cleanDocuments();
        FidesWorkSheetManager.setSelectedDocument(null, (boolean)true, (boolean)true);
        this.lastFile = null;
    }

    public void saveFile(StdUIComponent parentComponent, DocumentDTO document, FidesFileUIControllerAction saveFileAction) {
        boolean newFile = false;
        if (this.lastFile == null) {
            this.lastFile = StdJFileChooser.chooserSaveAsFile((Component)StdSwingUtil.getComponent((StdUIComponent)parentComponent), (String)"fides", null);
            newFile = true;
        }
        if (this.lastFile != null) {
            try {
                DocumentDTO doc = FidesWorkSheetManager.getSelectedDocument();
                doc.setName(this.lastFile.getName());
                doc = consumer.saveDocument(doc);
                saveFileAction.performAction(this.lastFile.getAbsolutePath());
                FidesWorkSheetManager.setSelectedDocument((DocumentDTO)doc, (boolean)false, (boolean)false);
                if (newFile) {
                    this.addToRecentFiles(this.lastFile.getCanonicalPath());
                }
            }
            catch (Exception ex) {
                StdUINotificationManager.showError((StdLogger)LOGGER, (String)("Cannot save document " + document.getName()), (Exception)ex);
            }
        }
        FidesWorkSheetManager.setDocumentChanged((boolean)false);
    }

    public void saveFileAs(StdUIComponent parentComponent, DocumentDTO document, FidesFileUIControllerAction saveFileAction) {
        String lastFilePath = this.fidesProperties.getProperty(FidesPropertyNames.CURRENT_FILE_PATH.name());
        File f = StdJFileChooser.chooserSaveAsFile((Component)StdSwingUtil.getComponent((StdUIComponent)parentComponent), (String)"fides", (String)lastFilePath);
        if (f != null) {
            this.lastFile = f;
            try {
                DocumentDTO doc = FidesWorkSheetManager.getSelectedDocument();
                doc.setName(this.lastFile.getName());
                doc = consumer.saveDocument(doc);
                saveFileAction.performAction(this.lastFile.getAbsolutePath());
                FidesWorkSheetManager.setSelectedDocument((DocumentDTO)doc, (boolean)false, (boolean)true);
                this.addToRecentFiles(this.lastFile.getCanonicalPath());
            }
            catch (Exception ex) {
                StdUINotificationManager.showError((StdLogger)LOGGER, (String)("Cannot save document " + document.getName()), (Exception)ex);
            }
        }
        FidesWorkSheetManager.setDocumentChanged((boolean)false);
    }

    public void saveFileAsPartialFile(StdUIComponent parentComponent, FidesFileUIControllerAction saveFileAction) {
        String lastFilePath = this.fidesProperties.getProperty(FidesPropertyNames.CURRENT_FILE_PATH.name());
        File f = StdJFileChooser.chooserSaveAsFile((Component)StdSwingUtil.getComponent((StdUIComponent)parentComponent), (String)"fides", (String)lastFilePath);
        if (f != null) {
            try {
                DocumentDTO doc = FidesWorkSheetManager.getSelectedDocument();
                String oldName = doc.getName();
                doc.setName(f.getName());
                doc = consumer.saveDocument(doc);
                doc.setName(oldName);
                FidesWorkSheetManager.setSelectedDocument((DocumentDTO)doc, (boolean)false, (boolean)false);
                saveFileAction.performAction(f.getAbsolutePath());
            }
            catch (Exception ex) {
                StdUINotificationManager.showError((StdLogger)LOGGER, (String)("Cannot proceed to save file " + f.getName()), (Exception)ex);
            }
        }
    }

    private void addToRecentFiles(String newFile) {
        this.recentFiles.remove(newFile);
        if (this.recentFiles.size() >= this.maxRecentFilesSize) {
            this.recentFiles.removeLast();
        }
        this.recentFiles.addFirst(newFile);
        this.fidesProperties.setProperty(FidesPropertyNames.RECENT_FILES.name(), String.join((CharSequence)";", this.recentFiles));
        this.fidesProperties.save();
    }

    public void loadFile(File f, FidesFileUIControllerAction loadFileAction) {
        if (f != null) {
            FidesWorkSheetManager.setDocumentChanged((boolean)false);
            this.lastFile = f;
            String filePath = this.lastFile.getAbsolutePath();
            this.cleanDocuments();
            DocumentDTO newDocument = null;
            try {
                newDocument = loadFileAction.performAction(filePath);
                FidesWorkSheetManager.getSelectedDocument();
                this.fidesProperties.setProperty(FidesPropertyNames.CURRENT_FILE_PATH.name(), filePath);
                this.fidesProperties.save();
                this.addToRecentFiles(this.lastFile.getCanonicalPath());
            }
            catch (Exception ex) {
                StdUINotificationManager.showError((StdLogger)LOGGER, (String)("Cannot read open-fides file : " + filePath), (Exception)ex);
                this.cleanDocuments();
                newDocument = null;
            }
            FidesWorkSheetManager.setSelectedDocument((DocumentDTO)newDocument, (boolean)true, (boolean)true);
        }
    }

    public void chooseAndLoadFile(StdUIComponent parentComponent, FidesFileUIControllerAction loadFileAction) {
        String lastFilePath = this.fidesProperties.getProperty(FidesPropertyNames.CURRENT_FILE_PATH.name());
        File f = lastFilePath == null || lastFilePath.isBlank() ? StdJFileChooser.chooserOpenFile((Component)StdSwingUtil.getComponent((StdUIComponent)parentComponent), (String)"xml;fides") : StdJFileChooser.chooserOpenFile((Component)StdSwingUtil.getComponent((StdUIComponent)parentComponent), (String)"xml;fides", (File)new File(lastFilePath));
        this.loadFile(f, loadFileAction);
    }

    public void simpleChooseAndLoadPartialFile(StdUIComponent parentComponent, FidesFileUIControllerAction loadFileAction) {
        String lastFilePath = this.fidesProperties.getProperty(FidesPropertyNames.CURRENT_FILE_PATH.name());
        File f = lastFilePath == null || lastFilePath.isBlank() ? StdJFileChooser.chooserOpenFile((Component)StdSwingUtil.getComponent((StdUIComponent)parentComponent), (String)"xml;fides") : StdJFileChooser.chooserOpenFile((Component)StdSwingUtil.getComponent((StdUIComponent)parentComponent), (String)"xml;fides", (File)new File(lastFilePath));
        try {
            DocumentDTO doc = loadFileAction.performAction(f.getAbsolutePath());
            FidesWorkSheetManager.setSelectedDocument((DocumentDTO)doc, (boolean)true, (boolean)false);
            FidesWorkSheetManager.setDocumentChanged((boolean)true);
        }
        catch (Exception e) {
            StdUINotificationManager.showError((StdLogger)LOGGER, (String)("Cannot read open-fides file : " + f.getAbsolutePath()), (Exception)e);
        }
    }

    private void cleanDocuments() {
        StdUndoRedoManager.clear();
        DocumentConsumer documentConsumer = (DocumentConsumer)StdSpringUtil.getBean(DocumentConsumer.class, (Object[])new Object[0]);
        List documents = new ArrayList();
        try {
            documents = documentConsumer.getAllDocuments();
        }
        catch (Exception e) {
            StdUINotificationManager.showError((StdLogger)LOGGER, (String)"Unable to fetch documents", (Exception)e);
        }
        for (DocumentDTO document : documents) {
            try {
                documentConsumer.deleteDocument(document);
            }
            catch (Exception e) {
                StdUINotificationManager.showError((StdLogger)LOGGER, (String)("Cannot delete document " + document.getName()), (Exception)e);
            }
        }
    }

    public LinkedList<String> getRecentFiles() {
        return this.recentFiles;
    }
}

